/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.model;

import java.util.ArrayList;
import java.util.List;
import org.apache.sqoop.classification.InterfaceAudience;
import org.apache.sqoop.classification.InterfaceStability;
import org.apache.sqoop.common.ErrorCode;
import org.apache.sqoop.common.SqoopException;
import org.apache.sqoop.model.MBooleanInput;
import org.apache.sqoop.model.MClonable;
import org.apache.sqoop.model.MConfig;
import org.apache.sqoop.model.MConfigType;
import org.apache.sqoop.model.MDateTimeInput;
import org.apache.sqoop.model.MEnumInput;
import org.apache.sqoop.model.MInput;
import org.apache.sqoop.model.MIntegerInput;
import org.apache.sqoop.model.MListInput;
import org.apache.sqoop.model.MLongInput;
import org.apache.sqoop.model.MMapInput;
import org.apache.sqoop.model.MStringInput;
import org.apache.sqoop.model.MValidatedElement;
import org.apache.sqoop.model.MValidator;
import org.apache.sqoop.model.ModelError;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public class MConfigList
extends MValidatedElement
implements MClonable {
    private final List<MConfig> configObjects;
    private final MConfigType type;

    public MConfigList(List<MConfig> configObjects, MConfigType type, List<MValidator> mValidators) {
        super(mValidators);
        this.configObjects = configObjects;
        this.type = type;
    }

    public List<MConfig> getConfigs() {
        return this.configObjects;
    }

    public MConfig getConfig(String configName) {
        for (MConfig config : this.configObjects) {
            if (!configName.equals(config.getName())) continue;
            return config;
        }
        throw new SqoopException((ErrorCode)ModelError.MODEL_010, "config name: " + configName);
    }

    public MConfigType getType() {
        return this.type;
    }

    public MInput getInput(String name) {
        String[] parts = name.split("\\.");
        if (parts.length != 2) {
            throw new SqoopException((ErrorCode)ModelError.MODEL_009, name);
        }
        return this.getConfig(parts[0]).getInput(name);
    }

    public MStringInput getStringInput(String name) {
        return (MStringInput)this.getInput(name);
    }

    public MEnumInput getEnumInput(String name) {
        return (MEnumInput)this.getInput(name);
    }

    public MIntegerInput getIntegerInput(String name) {
        return (MIntegerInput)this.getInput(name);
    }

    public MLongInput getLongInput(String name) {
        return (MLongInput)this.getInput(name);
    }

    public MMapInput getMapInput(String name) {
        return (MMapInput)this.getInput(name);
    }

    public MBooleanInput getBooleanInput(String name) {
        return (MBooleanInput)this.getInput(name);
    }

    public MListInput getListInput(String name) {
        return (MListInput)this.getInput(name);
    }

    public MDateTimeInput getDateTimeInput(String name) {
        return (MDateTimeInput)this.getInput(name);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MConfigList)) {
            return false;
        }
        MConfigList mConfigList = (MConfigList)o;
        return this.configObjects.equals(mConfigList.configObjects) && this.type.equals((Object)mConfigList.type);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.type.hashCode();
        for (MConfig config : this.configObjects) {
            result = 31 * result + config.hashCode();
        }
        return result;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("Configs: ");
        for (MConfig config : this.configObjects) {
            sb.append(config.toString());
        }
        sb.append("Type: " + (Object)((Object)this.type));
        return sb.toString();
    }

    @Override
    public MConfigList clone(boolean cloneWithValue) {
        ArrayList<MConfig> copyConfigs = null;
        if (this.getConfigs() != null) {
            copyConfigs = new ArrayList<MConfig>();
            for (MConfig itr : this.getConfigs()) {
                MConfig newConfig = itr.clone(cloneWithValue);
                newConfig.setPersistenceId(itr.getPersistenceId());
                copyConfigs.add(newConfig);
            }
        }
        MConfigList copyConfigList = new MConfigList(copyConfigs, this.type, this.getCloneOfValidators());
        return copyConfigList;
    }
}

