/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.model;

import org.apache.sqoop.classification.InterfaceAudience;
import org.apache.sqoop.classification.InterfaceStability;
import org.apache.sqoop.model.MAccountableEntity;
import org.apache.sqoop.model.MClonable;
import org.apache.sqoop.model.MConfig;
import org.apache.sqoop.model.MLinkConfig;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public class MLink
extends MAccountableEntity
implements MClonable {
    private String connectorName;
    private final MLinkConfig connectorLinkConfig;

    public MLink(String connectorName, MLinkConfig linkConfig) {
        this.connectorName = connectorName;
        this.connectorLinkConfig = linkConfig;
    }

    public MLink(MLink other) {
        this(other, other.connectorLinkConfig.clone(true));
    }

    public MLink(MLink other, MLinkConfig linkConfig) {
        super(other);
        this.connectorName = other.connectorName;
        this.connectorLinkConfig = linkConfig;
        this.setPersistenceId(other.getPersistenceId());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("link: ").append(this.getName());
        sb.append(" link-config: ").append(this.connectorLinkConfig);
        return sb.toString();
    }

    public String getConnectorName() {
        return this.connectorName;
    }

    public MLinkConfig getConnectorLinkConfig() {
        return this.connectorLinkConfig;
    }

    public MConfig getConnectorLinkConfig(String configName) {
        return this.connectorLinkConfig.getConfig(configName);
    }

    @Override
    public MLink clone(boolean cloneWithValue) {
        if (cloneWithValue) {
            return new MLink(this);
        }
        return new MLink(this.connectorName, this.connectorLinkConfig.clone(false));
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof MLink)) {
            return false;
        }
        MLink mLink = (MLink)object;
        return mLink.connectorName.equals(this.connectorName) && mLink.getPersistenceId() == this.getPersistenceId() && mLink.connectorLinkConfig.equals(this.connectorLinkConfig);
    }

    public int hashCode() {
        int result = this.connectorName != null ? this.connectorName.hashCode() : 0;
        result = 31 * result + (this.connectorLinkConfig != null ? this.connectorLinkConfig.hashCode() : 0);
        return result;
    }
}

