/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.utils;

import java.io.IOException;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.Callable;
import org.apache.log4j.Logger;
import org.apache.sqoop.classification.InterfaceAudience;
import org.apache.sqoop.classification.InterfaceStability;
import org.apache.sqoop.common.ErrorCode;
import org.apache.sqoop.common.SqoopException;
import org.apache.sqoop.error.code.CoreError;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public final class ClassUtils {
    private static final Logger LOG = Logger.getLogger(ClassUtils.class);
    private static final Map<ClassLoader, Map<String, WeakReference<Class<?>>>> CACHE_CLASSES = new WeakHashMap();
    private static final Class<?> NEGATIVE_CACHE_SENTINEL = NegativeCacheSentinel.class;

    public static Class<?> loadClass(String className) {
        return ClassUtils.loadClassWithClassLoader(className, ClassUtils.getClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Class<?> loadClassWithClassLoader(String className, ClassLoader loader) {
        Map<String, WeakReference<Class<Object>>> map;
        if (className == null) {
            return null;
        }
        Map<ClassLoader, Map<String, WeakReference<Class<?>>>> map2 = CACHE_CLASSES;
        synchronized (map2) {
            map = CACHE_CLASSES.get(loader);
            if (map == null) {
                map = Collections.synchronizedMap(new WeakHashMap());
                CACHE_CLASSES.put(loader, map);
            }
        }
        Class<?> klass = null;
        WeakReference<Class<Object>> ref = map.get(className);
        if (ref != null) {
            klass = (Class<?>)ref.get();
        }
        if (klass == null) {
            try {
                klass = Class.forName(className, true, loader);
            }
            catch (ClassNotFoundException ex) {
                map.put(className, new WeakReference(NEGATIVE_CACHE_SENTINEL));
                LOG.debug((Object)("Exception while loading class: " + className), (Throwable)ex);
                return null;
            }
            map.put(className, new WeakReference(klass));
            return klass;
        }
        if (klass == NEGATIVE_CACHE_SENTINEL) {
            return null;
        }
        return klass;
    }

    public static Object instantiate(String className, Object ... args) {
        return ClassUtils.instantiateWithClassLoader(className, ClassUtils.getClassLoader(), args);
    }

    public static Object instantiateWithClassLoader(String className, ClassLoader loader, Object ... args) {
        return ClassUtils.instantiate(ClassUtils.loadClassWithClassLoader(className, loader), args);
    }

    public static Object instantiate(Class klass, Object ... args) {
        Constructor<?>[] constructors;
        if (klass == null) {
            return null;
        }
        for (Constructor<?> constructor : constructors = klass.getConstructors()) {
            try {
                return constructor.newInstance(args);
            }
            catch (InvocationTargetException e) {
                LOG.debug((Object)"Can't instantiate object.", (Throwable)e);
            }
            catch (InstantiationException e) {
                LOG.trace((Object)"Can't instantiate object.", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                LOG.trace((Object)"Can't instantiate object.", (Throwable)e);
            }
            catch (IllegalArgumentException e) {
                LOG.trace((Object)"Can't instantiate object.", (Throwable)e);
            }
        }
        return null;
    }

    public static String jarForClass(String className) {
        return ClassUtils.jarForClassWithClassLoader(className, ClassUtils.getClassLoader());
    }

    public static String jarForClassWithClassLoader(String className, ClassLoader loader) {
        Class<?> klass = ClassUtils.loadClassWithClassLoader(className, loader);
        return ClassUtils.jarForClass(klass);
    }

    public static String jarForClass(Class klass) {
        String jarPath = null;
        String class_file = klass.getName().replaceAll("\\.", "/") + ".class";
        try {
            URL url = ClassUtils.getClassLoader().getResource(class_file);
            String path = url.getPath();
            path = URLDecoder.decode(path, "UTF-8");
            if ("jar".equals(url.getProtocol())) {
                jarPath = path.replaceAll("!.*$", "");
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (jarPath == null) {
            throw new SqoopException((ErrorCode)CoreError.CORE_0009, "failed to find jar for class: " + klass.getName());
        }
        return jarPath;
    }

    public static String[] getEnumStrings(Class klass) {
        if (!klass.isEnum()) {
            return new String[0];
        }
        ArrayList<String> values = new ArrayList<String>();
        try {
            Method methodName = klass.getMethod("name", new Class[0]);
            for (Object constant : klass.getEnumConstants()) {
                values.add((String)methodName.invoke(constant, new Object[0]));
            }
        }
        catch (IllegalAccessException | NoSuchMethodException | RuntimeException | InvocationTargetException e) {
            LOG.error((Object)("Can't get list of values from enumeration " + klass.getCanonicalName()), (Throwable)e);
            return new String[0];
        }
        return values.toArray(new String[values.size()]);
    }

    public static void clearCache() {
        CACHE_CLASSES.clear();
    }

    public static ClassLoader getClassLoader() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = ClassUtils.class.getClassLoader();
        }
        return classLoader;
    }

    public static Object executeWithClassLoader(ClassLoader loader, Callable<?> callable) {
        ClassLoader oldContextClassLoader = Thread.currentThread().getContextClassLoader();
        if (loader != null) {
            Thread.currentThread().setContextClassLoader(loader);
        }
        try {
            Object obj = callable.call();
            return obj;
        }
        catch (Exception e) {
            if (e instanceof SqoopException) {
                throw (SqoopException)e;
            }
            throw new SqoopException((ErrorCode)CoreError.CORE_0000, (Throwable)e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldContextClassLoader);
        }
    }

    private ClassUtils() {
    }

    private static abstract class NegativeCacheSentinel {
        private NegativeCacheSentinel() {
        }
    }
}

