/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.utils;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import org.apache.sqoop.classification.InterfaceAudience;
import org.apache.sqoop.classification.InterfaceStability;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public final class UrlSafeUtils {
    public static final String ENCODING_UTF8 = "UTF-8";

    public static String urlEncode(String string) {
        try {
            return URLEncoder.encode(string, ENCODING_UTF8);
        }
        catch (UnsupportedEncodingException uee) {
            throw new RuntimeException(uee);
        }
    }

    public static String urlDecode(String string) {
        try {
            return URLDecoder.decode(string, ENCODING_UTF8);
        }
        catch (UnsupportedEncodingException uee) {
            throw new RuntimeException(uee);
        }
    }

    public static String urlPathEncode(String path) {
        try {
            return URLEncoder.encode(URLEncoder.encode(path, ENCODING_UTF8), ENCODING_UTF8);
        }
        catch (UnsupportedEncodingException uee) {
            throw new RuntimeException(uee);
        }
    }

    public static String urlPathDecode(String path) {
        try {
            return URLDecoder.decode(URLDecoder.decode(path, ENCODING_UTF8), ENCODING_UTF8);
        }
        catch (UnsupportedEncodingException uee) {
            throw new RuntimeException(uee);
        }
    }

    private UrlSafeUtils() {
    }
}

