/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.validation.validators;

import com.google.common.base.Strings;
import org.apache.sqoop.classification.InterfaceAudience;
import org.apache.sqoop.classification.InterfaceStability;
import org.apache.sqoop.validation.Status;
import org.apache.sqoop.validation.validators.AbstractValidator;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public class CSVURIValidator
extends AbstractValidator<String> {
    @Override
    public void validate(String str) {
        if (!Strings.isNullOrEmpty((String)str)) {
            String[] pairs;
            for (String pair : pairs = str.split("\\s*,\\s*")) {
                String[] parts = pair.split("\\s*:\\s*");
                if (parts.length != 2) {
                    this.addMessage(Status.ERROR, "can't parse into host:port pairs");
                    continue;
                }
                String[] rightParts = parts[1].split("/");
                try {
                    int port = Integer.parseInt(rightParts[0]);
                    if (port < 0) {
                        this.addMessage(Status.ERROR, "Can't parse port less than 0");
                        continue;
                    }
                    if (port <= 65535) continue;
                    this.addMessage(Status.ERROR, "Can't parse port greater than 65535");
                }
                catch (NumberFormatException e) {
                    this.addMessage(Status.ERROR, "Can't parse port");
                }
            }
        } else {
            this.addMessage(Status.ERROR, "Can't be null nor empty");
        }
    }
}

