/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.validation.validators;

import org.apache.sqoop.classification.InterfaceAudience;
import org.apache.sqoop.classification.InterfaceStability;
import org.apache.sqoop.validation.Message;
import org.apache.sqoop.validation.Status;
import org.apache.sqoop.validation.validators.AbstractValidator;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public class ClassAvailable
extends AbstractValidator<String> {
    @Override
    public void validate(String klass) {
        if (klass == null) {
            this.addMessage(new Message(Status.ERROR, "Class cannot be null"));
        } else {
            try {
                Class.forName(klass);
            }
            catch (ClassNotFoundException e) {
                this.addMessage(new Message(Status.ERROR, "Class not found"));
            }
        }
    }
}

