/*
 * Decompiled with CFR 0.152.
 */
package org.sitemesh.microbenchmark.contentprocessor;

import com.sun.japex.JapexDriverBase;
import com.sun.japex.TestCase;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.FileChannel;
import org.sitemesh.content.ContentProcessor;
import org.sitemesh.webapp.contentfilter.io.TextEncoder;

public abstract class BaseContentProcessorDriver
extends JapexDriverBase {
    private ContentProcessor contentProcessor;
    private CharBuffer data;

    protected abstract ContentProcessor createProcessor();

    public void prepare(TestCase testCase) {
        try {
            this.contentProcessor = this.createProcessor();
            this.data = this.loadFile(new File(testCase.getParam("japex.inputFile")));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void run(TestCase testCase) {
        try {
            this.contentProcessor.build(this.data, null);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CharBuffer loadFile(File file) throws IOException {
        FileInputStream inputStream = new FileInputStream(file);
        try {
            FileChannel channel = inputStream.getChannel();
            ByteBuffer bytes = ByteBuffer.allocate((int)channel.size());
            channel.read(bytes);
            CharBuffer charBuffer = TextEncoder.encode((ByteBuffer)bytes, null);
            return charBuffer;
        }
        finally {
            inputStream.close();
        }
    }
}

