/*
 * Decompiled with CFR 0.152.
 */
package org.springblade.core.oss.aliyun;

import com.aliyun.oss.OSSClient;
import com.aliyun.oss.common.utils.BinaryUtil;
import com.aliyun.oss.model.MatchMode;
import com.aliyun.oss.model.ObjectMetadata;
import com.aliyun.oss.model.PolicyConditions;
import com.aliyun.oss.model.PutObjectResult;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import org.springblade.core.oss.OssTemplate;
import org.springblade.core.oss.model.BladeFile;
import org.springblade.core.oss.model.OssFile;
import org.springblade.core.oss.props.OssProperties;
import org.springblade.core.oss.rule.OssRule;
import org.springblade.core.tool.jackson.JsonUtil;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;

public class AliossTemplate
implements OssTemplate {
    private OSSClient ossClient;
    private OssProperties ossProperties;
    private OssRule ossRule;

    public void makeBucket(String bucketName) {
        if (!this.bucketExists(bucketName)) {
            this.ossClient.createBucket(this.getBucketName(bucketName));
        }
    }

    public void removeBucket(String bucketName) {
        this.ossClient.deleteBucket(this.getBucketName(bucketName));
    }

    public boolean bucketExists(String bucketName) {
        return this.ossClient.doesBucketExist(this.getBucketName(bucketName));
    }

    public void copyFile(String bucketName, String fileName, String destBucketName) {
        this.ossClient.copyObject(this.getBucketName(bucketName), fileName, this.getBucketName(destBucketName), fileName);
    }

    public void copyFile(String bucketName, String fileName, String destBucketName, String destFileName) {
        this.ossClient.copyObject(this.getBucketName(bucketName), fileName, this.getBucketName(destBucketName), destFileName);
    }

    public OssFile statFile(String fileName) {
        return this.statFile(this.ossProperties.getBucketName(), fileName);
    }

    public OssFile statFile(String bucketName, String fileName) {
        ObjectMetadata stat = this.ossClient.getObjectMetadata(this.getBucketName(bucketName), fileName);
        OssFile ossFile = new OssFile();
        ossFile.setName(fileName);
        ossFile.setLink(this.fileLink(ossFile.getName()));
        ossFile.setHash(stat.getContentMD5());
        ossFile.setLength(stat.getContentLength());
        ossFile.setPutTime(stat.getLastModified());
        ossFile.setContentType(stat.getContentType());
        return ossFile;
    }

    public String filePath(String fileName) {
        return this.getOssHost().concat("/").concat(fileName);
    }

    public String filePath(String bucketName, String fileName) {
        return this.getOssHost(bucketName).concat("/").concat(fileName);
    }

    public String fileLink(String fileName) {
        return this.getOssHost().concat("/").concat(fileName);
    }

    public String fileLink(String bucketName, String fileName) {
        return this.getOssHost(bucketName).concat("/").concat(fileName);
    }

    public BladeFile putFile(MultipartFile file) {
        return this.putFile(this.ossProperties.getBucketName(), file.getOriginalFilename(), file);
    }

    public BladeFile putFile(String fileName, MultipartFile file) {
        return this.putFile(this.ossProperties.getBucketName(), fileName, file);
    }

    public BladeFile putFile(String bucketName, String fileName, MultipartFile file) {
        return this.putFile(bucketName, fileName, file.getInputStream());
    }

    public BladeFile putFile(String fileName, InputStream stream) {
        return this.putFile(this.ossProperties.getBucketName(), fileName, stream);
    }

    public BladeFile putFile(String bucketName, String fileName, InputStream stream) {
        return this.put(bucketName, stream, fileName, false);
    }

    public BladeFile put(String bucketName, InputStream stream, String key, boolean cover) {
        this.makeBucket(bucketName);
        String originalName = key;
        key = this.getFileName(key);
        if (cover) {
            this.ossClient.putObject(this.getBucketName(bucketName), key, stream);
        } else {
            PutObjectResult response = this.ossClient.putObject(this.getBucketName(bucketName), key, stream);
            int retryCount = 5;
            for (int retry = 0; StringUtils.isEmpty((Object)response.getETag()) && retry < retryCount; ++retry) {
                response = this.ossClient.putObject(this.getBucketName(bucketName), key, stream);
            }
        }
        BladeFile file = new BladeFile();
        file.setOriginalName(originalName);
        file.setName(key);
        file.setDomain(this.getOssHost(bucketName));
        file.setLink(this.fileLink(bucketName, key));
        return file;
    }

    public void removeFile(String fileName) {
        this.ossClient.deleteObject(this.getBucketName(), fileName);
    }

    public void removeFile(String bucketName, String fileName) {
        this.ossClient.deleteObject(this.getBucketName(bucketName), fileName);
    }

    public void removeFiles(List<String> fileNames) {
        fileNames.forEach(this::removeFile);
    }

    public void removeFiles(String bucketName, List<String> fileNames) {
        fileNames.forEach(fileName -> this.removeFile(this.getBucketName(bucketName), (String)fileName));
    }

    private String getBucketName() {
        return this.getBucketName(this.ossProperties.getBucketName());
    }

    private String getBucketName(String bucketName) {
        return this.ossRule.bucketName(bucketName);
    }

    private String getFileName(String originalFilename) {
        return this.ossRule.fileName(originalFilename);
    }

    public String getUploadToken() {
        return this.getUploadToken(this.ossProperties.getBucketName());
    }

    public String getUploadToken(String bucketName) {
        return this.getUploadToken(bucketName, (Long)this.ossProperties.getArgs().get("expireTime", (Object)3600L));
    }

    public String getUploadToken(String bucketName, long expireTime) {
        String baseDir = "upload";
        long expireEndTime = System.currentTimeMillis() + expireTime * 1000L;
        Date expiration = new Date(expireEndTime);
        PolicyConditions policyConds = new PolicyConditions();
        policyConds.addConditionItem("content-length-range", 0L, (long)((Integer)this.ossProperties.getArgs().get("contentLengthRange", (Object)0xA00000)).intValue());
        policyConds.addConditionItem(MatchMode.StartWith, "key", baseDir);
        String postPolicy = this.ossClient.generatePostPolicy(expiration, policyConds);
        byte[] binaryData = postPolicy.getBytes(StandardCharsets.UTF_8);
        String encodedPolicy = BinaryUtil.toBase64String((byte[])binaryData);
        String postSignature = this.ossClient.calculatePostSignature(postPolicy);
        LinkedHashMap<String, String> respMap = new LinkedHashMap<String, String>(16);
        respMap.put("accessid", this.ossProperties.getAccessKey());
        respMap.put("policy", encodedPolicy);
        respMap.put("signature", postSignature);
        respMap.put("dir", baseDir);
        respMap.put("host", this.getOssHost(bucketName));
        respMap.put("expire", String.valueOf(expireEndTime / 1000L));
        return JsonUtil.toJson(respMap);
    }

    public String getOssHost(String bucketName) {
        String prefix = this.ossProperties.getEndpoint().contains("https://") ? "https://" : "http://";
        return prefix + this.getBucketName(bucketName) + "." + this.ossProperties.getEndpoint().replaceFirst(prefix, "");
    }

    public String getOssHost() {
        return this.getOssHost(this.ossProperties.getBucketName());
    }

    public AliossTemplate(OSSClient ossClient, OssProperties ossProperties, OssRule ossRule) {
        this.ossClient = ossClient;
        this.ossProperties = ossProperties;
        this.ossRule = ossRule;
    }
}

