/*
 * Decompiled with CFR 0.152.
 */
package org.springblade.core.sms.tencent;

import com.github.qcloudsms.SmsMultiSender;
import com.github.qcloudsms.SmsMultiSenderResult;
import com.github.qcloudsms.httpclient.HTTPException;
import java.io.IOException;
import java.time.Duration;
import java.util.Collection;
import org.springblade.core.redis.cache.BladeRedis;
import org.springblade.core.sms.SmsTemplate;
import org.springblade.core.sms.model.SmsCode;
import org.springblade.core.sms.model.SmsData;
import org.springblade.core.sms.model.SmsResponse;
import org.springblade.core.sms.props.SmsProperties;
import org.springblade.core.tool.utils.Func;
import org.springblade.core.tool.utils.StringUtil;
import org.springframework.http.HttpStatus;

public class TencentSmsTemplate
implements SmsTemplate {
    private static final int SUCCESS = 0;
    private static final String NATION_CODE = "86";
    private SmsProperties smsProperties;
    private SmsMultiSender smsSender;
    private BladeRedis bladeRedis;

    public SmsResponse sendMessage(SmsData smsData, Collection<String> phones) {
        try {
            Collection values = smsData.getParams().values();
            String[] params = StringUtil.toStringArray(values);
            SmsMultiSenderResult senderResult = this.smsSender.sendWithParam(NATION_CODE, StringUtil.toStringArray(phones), Func.toInt((Object)this.smsProperties.getTemplateId()), params, this.smsProperties.getSignName(), "", "");
            return new SmsResponse(senderResult.result == 0, Integer.valueOf(senderResult.result), senderResult.toString());
        }
        catch (HTTPException | IOException e) {
            e.printStackTrace();
            return new SmsResponse(Boolean.FALSE.booleanValue(), Integer.valueOf(HttpStatus.INTERNAL_SERVER_ERROR.value()), e.getMessage());
        }
    }

    public SmsCode sendValidate(SmsData smsData, String phone) {
        SmsCode smsCode = new SmsCode();
        boolean temp = this.sendSingle(smsData, phone);
        if (temp && StringUtil.isNotBlank((CharSequence)smsData.getKey())) {
            String id = StringUtil.randomUUID();
            String value = (String)smsData.getParams().get(smsData.getKey());
            this.bladeRedis.setEx("blade:sms::captcha:" + id, (Object)value, Duration.ofMinutes(30L));
            smsCode.setId(id).setValue(value);
        } else {
            smsCode.setSuccess(Boolean.FALSE.booleanValue());
        }
        return smsCode;
    }

    public boolean validateMessage(SmsCode smsCode) {
        String id = smsCode.getId();
        String value = smsCode.getValue();
        String cache = (String)this.bladeRedis.get("blade:sms::captcha:" + id);
        if (StringUtil.isNotBlank((CharSequence)value) && StringUtil.equalsIgnoreCase((CharSequence)cache, (CharSequence)value)) {
            this.bladeRedis.del("blade:sms::captcha:" + id);
            return true;
        }
        return false;
    }

    public TencentSmsTemplate(SmsProperties smsProperties, SmsMultiSender smsSender, BladeRedis bladeRedis) {
        this.smsProperties = smsProperties;
        this.smsSender = smsSender;
        this.bladeRedis = bladeRedis;
    }
}

