/*
 * Decompiled with CFR 0.152.
 */
package org.springblade.core.sms.tencent.config;

import com.github.qcloudsms.SmsMultiSender;
import org.springblade.core.redis.cache.BladeRedis;
import org.springblade.core.sms.props.SmsProperties;
import org.springblade.core.sms.tencent.TencentSmsTemplate;
import org.springblade.core.tool.utils.Func;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={SmsProperties.class})
@ConditionalOnProperty(value={"sms.name"}, havingValue="tencent")
public class TencentSmsConfiguration {
    private BladeRedis bladeRedis;

    @Bean
    public TencentSmsTemplate tencentSmsTemplate(SmsProperties smsProperties) {
        SmsMultiSender smsSender = new SmsMultiSender(Func.toInt((Object)smsProperties.getAccessKey()), smsProperties.getSecretKey());
        return new TencentSmsTemplate(smsProperties, smsSender, this.bladeRedis);
    }

    public TencentSmsConfiguration(BladeRedis bladeRedis) {
        this.bladeRedis = bladeRedis;
    }
}

