/*
 * Decompiled with CFR 0.152.
 */
package org.springblade.core.sms.yunpian;

import com.yunpian.sdk.YunpianClient;
import com.yunpian.sdk.model.Result;
import java.time.Duration;
import java.util.Collection;
import java.util.Map;
import org.springblade.core.redis.cache.BladeRedis;
import org.springblade.core.sms.SmsTemplate;
import org.springblade.core.sms.model.SmsCode;
import org.springblade.core.sms.model.SmsData;
import org.springblade.core.sms.model.SmsResponse;
import org.springblade.core.sms.props.SmsProperties;
import org.springblade.core.tool.support.Kv;
import org.springblade.core.tool.utils.PlaceholderUtil;
import org.springblade.core.tool.utils.StringUtil;

public class YunpianSmsTemplate
implements SmsTemplate {
    private SmsProperties smsProperties;
    private YunpianClient client;
    private BladeRedis bladeRedis;

    public SmsResponse sendMessage(SmsData smsData, Collection<String> phones) {
        String templateId = this.smsProperties.getTemplateId();
        String templateText = PlaceholderUtil.getResolver((String)"#", (String)"#").resolveByMap(templateId, (Map)Kv.create().setAll(smsData.getParams()));
        Map param = this.client.newParam(2);
        param.put("mobile", StringUtil.join(phones));
        param.put("text", templateText);
        Result result = this.client.sms().multi_send(param);
        return new SmsResponse(result.getCode() == 0, result.getCode(), result.toString());
    }

    public SmsCode sendValidate(SmsData smsData, String phone) {
        SmsCode smsCode = new SmsCode();
        boolean temp = this.sendSingle(smsData, phone);
        if (temp && StringUtil.isNotBlank((CharSequence)smsData.getKey())) {
            String id = StringUtil.randomUUID();
            String value = (String)smsData.getParams().get(smsData.getKey());
            this.bladeRedis.setEx("blade:sms::captcha:" + id, (Object)value, Duration.ofMinutes(30L));
            smsCode.setId(id).setValue(value);
        } else {
            smsCode.setSuccess(Boolean.FALSE.booleanValue());
        }
        return smsCode;
    }

    public boolean validateMessage(SmsCode smsCode) {
        String id = smsCode.getId();
        String value = smsCode.getValue();
        String cache = (String)this.bladeRedis.get("blade:sms::captcha:" + id);
        if (StringUtil.isNotBlank((CharSequence)value) && StringUtil.equalsIgnoreCase((CharSequence)cache, (CharSequence)value)) {
            this.bladeRedis.del("blade:sms::captcha:" + id);
            return true;
        }
        return false;
    }

    public YunpianSmsTemplate(SmsProperties smsProperties, YunpianClient client, BladeRedis bladeRedis) {
        this.smsProperties = smsProperties;
        this.client = client;
        this.bladeRedis = bladeRedis;
    }
}

