/*
 * Decompiled with CFR 0.152.
 */
package org.springblade.core.sms.yunpian.config;

import com.yunpian.sdk.YunpianClient;
import org.springblade.core.redis.cache.BladeRedis;
import org.springblade.core.sms.props.SmsProperties;
import org.springblade.core.sms.yunpian.YunpianSmsTemplate;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={SmsProperties.class})
@ConditionalOnProperty(value={"sms.name"}, havingValue="yunpian")
public class YunpianSmsConfiguration {
    private BladeRedis bladeRedis;

    @Bean
    public YunpianSmsTemplate yunpianSmsTemplate(SmsProperties smsProperties) {
        YunpianClient client = new YunpianClient(smsProperties.getAccessKey()).init();
        return new YunpianSmsTemplate(smsProperties, client, this.bladeRedis);
    }

    public YunpianSmsConfiguration(BladeRedis bladeRedis) {
        this.bladeRedis = bladeRedis;
    }
}

