/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.context.properties;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.framework.Advised;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.boot.context.properties.ConfigurationPropertiesBinder;
import org.springframework.boot.context.properties.ConfigurationPropertiesBinderBuilder;
import org.springframework.cloud.context.environment.EnvironmentChangeEvent;
import org.springframework.cloud.context.properties.ConfigurationPropertiesBeans;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationListener;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.jmx.export.annotation.ManagedAttribute;
import org.springframework.jmx.export.annotation.ManagedOperation;
import org.springframework.jmx.export.annotation.ManagedResource;
import org.springframework.stereotype.Component;

@Component
@ManagedResource
public class ConfigurationPropertiesRebinder
implements ApplicationContextAware,
ApplicationListener<EnvironmentChangeEvent> {
    private static final Log log = LogFactory.getLog(ConfigurationPropertiesRebinder.class);
    private ConfigurationPropertiesBeans beans;
    private ConfigurationPropertiesBinder binder;
    private ApplicationContext applicationContext;
    private Map<String, Exception> errors = new ConcurrentHashMap<String, Exception>();
    private boolean resetting = false;

    public ConfigurationPropertiesRebinder(ConfigurationPropertiesBeans beans) {
        this.beans = beans;
    }

    private ConfigurationPropertiesBinder getBinder() {
        if (this.binder == null) {
            ConfigurableEnvironment environment = null;
            Environment object = this.applicationContext.getEnvironment();
            if (!(object instanceof ConfigurableEnvironment)) {
                log.warn((Object)"Environment is not of type ConfigurableEnvironment");
                environment = new StandardEnvironment();
            } else {
                environment = (ConfigurableEnvironment)object;
            }
            this.binder = new ConfigurationPropertiesBinderBuilder(this.applicationContext).withPropertySources((Iterable)environment.getPropertySources()).build();
        }
        return this.binder;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public Map<String, Exception> getErrors() {
        return this.errors;
    }

    @ManagedOperation
    public void rebind() {
        this.errors.clear();
        if (this.binder != null) {
            this.resetting = true;
            this.resetBinder();
        }
        for (String name : this.beans.getBeanNames()) {
            this.rebind(name);
        }
        this.resetting = false;
    }

    @ManagedOperation
    public boolean rebind(String name) {
        if (!this.beans.getBeanNames().contains(name)) {
            return false;
        }
        if (this.binder != null && !this.resetting) {
            this.resetBinder();
        }
        if (this.applicationContext != null) {
            try {
                Object bean = this.applicationContext.getBean(name);
                if (AopUtils.isCglibProxy((Object)bean)) {
                    bean = ConfigurationPropertiesRebinder.getTargetObject(bean);
                }
                this.getBinder().bind(bean);
                this.applicationContext.getAutowireCapableBeanFactory().initializeBean(bean, name);
                return true;
            }
            catch (RuntimeException e) {
                this.errors.put(name, e);
                throw e;
            }
        }
        return false;
    }

    private void resetBinder() {
        this.binder = null;
    }

    private static <T> T getTargetObject(Object candidate) {
        try {
            if (AopUtils.isAopProxy((Object)candidate) && candidate instanceof Advised) {
                return (T)((Advised)candidate).getTargetSource().getTarget();
            }
        }
        catch (Exception ex) {
            throw new IllegalStateException("Failed to unwrap proxied object", ex);
        }
        return (T)candidate;
    }

    @ManagedAttribute
    public Set<String> getBeanNames() {
        return new HashSet<String>(this.beans.getBeanNames());
    }

    public void onApplicationEvent(EnvironmentChangeEvent event) {
        this.rebind();
    }
}

