/*
 * Decompiled with CFR 0.152.
 */
package com.cxqm.xiaoerke.wechat.service.impl;

import com.cxqm.xiaoerke.common.bean.IErrorInfo;
import com.cxqm.xiaoerke.common.bean.ParamNotNullError;
import com.cxqm.xiaoerke.common.junit.AssertEx;
import com.cxqm.xiaoerke.common.utils.SpringContextHolder;
import com.cxqm.xiaoerke.wechat.beans.BaseWechatBean;
import com.cxqm.xiaoerke.wechat.beans.WechatErrors;
import com.cxqm.xiaoerke.wechat.dao.WechatQrcodeForeverDao;
import com.cxqm.xiaoerke.wechat.dao.WechatSubscriptionDao;
import com.cxqm.xiaoerke.wechat.entity.WechatQrcodeForever;
import com.cxqm.xiaoerke.wechat.entity.WechatSubscription;
import com.cxqm.xiaoerke.wechat.example.WechatQrcodeForeverExample;
import com.cxqm.xiaoerke.wechat.service.WechatQrcodeForeverService;
import com.cxqm.xiaoerke.wechat.utils.WechatUtil;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WechatQrcodeForeverServiceImpl
implements WechatQrcodeForeverService {
    @Autowired
    WechatQrcodeForeverDao wechatQrcodeForeverDao;
    @Autowired
    WechatSubscriptionDao wechatSubscriptionDao;

    private List<WechatQrcodeForever> getPerfectMatchList(WechatQrcodeForever qrcodeForever) {
        WechatQrcodeForeverExample example = new WechatQrcodeForeverExample();
        if (qrcodeForever != null) {
            WechatQrcodeForeverExample.Criteria criteria = example.createCriteria();
            if (qrcodeForever.getId() != null) {
                criteria.andIdEqualTo(qrcodeForever.getId());
            }
            if (qrcodeForever.getCode() != null) {
                criteria.andCodeEqualTo(qrcodeForever.getCode());
            }
            if (qrcodeForever.getSubscriptionId() != null) {
                criteria.andSubscriptionIdEqualTo(qrcodeForever.getSubscriptionId());
            }
            if (qrcodeForever.getSpare1Str() != null) {
                criteria.andSpare1StrEqualTo(qrcodeForever.getSpare1Str());
            } else {
                criteria.andSpare1StrIsNull();
            }
            if (qrcodeForever.getSpare2Str() != null) {
                criteria.andSpare2StrEqualTo(qrcodeForever.getSpare2Str());
            } else {
                criteria.andSpare2StrIsNull();
            }
            if (qrcodeForever.getSpare3Str() != null) {
                criteria.andSpare3StrEqualTo(qrcodeForever.getSpare3Str());
            } else {
                criteria.andSpare3StrIsNull();
            }
            if (qrcodeForever.getSpare4Str() != null) {
                criteria.andSpare4StrEqualTo(qrcodeForever.getSpare4Str());
            } else {
                criteria.andSpare4StrIsNull();
            }
            if (qrcodeForever.getSpare5Str() != null) {
                criteria.andSpare5StrEqualTo(qrcodeForever.getSpare5Str());
            } else {
                criteria.andSpare5StrIsNull();
            }
            if (qrcodeForever.getSpare1Num() != null) {
                criteria.andSpare1NumEqualTo(qrcodeForever.getSpare1Num());
            } else {
                criteria.andSpare1NumIsNull();
            }
            if (qrcodeForever.getSpare2Num() != null) {
                criteria.andSpare2NumEqualTo(qrcodeForever.getSpare2Num());
            } else {
                criteria.andSpare2NumIsNull();
            }
            if (qrcodeForever.getSpare3Num() != null) {
                criteria.andSpare3NumEqualTo(qrcodeForever.getSpare3Num());
            } else {
                criteria.andSpare3NumIsNull();
            }
            if (qrcodeForever.getSpare1Date() != null) {
                criteria.andSpare1DateEqualTo(qrcodeForever.getSpare1Date());
            } else {
                criteria.andSpare1DateIsNull();
            }
            if (qrcodeForever.getSpare2Date() != null) {
                criteria.andSpare2DateEqualTo(qrcodeForever.getSpare2Date());
            } else {
                criteria.andSpare2DateIsNull();
            }
            if (qrcodeForever.getSpare3Date() != null) {
                criteria.andSpare3DateEqualTo(qrcodeForever.getSpare3Date());
            } else {
                criteria.andSpare3DateIsNull();
            }
        }
        return this.wechatQrcodeForeverDao.selectByExample(example);
    }

    public WechatQrcodeForever createForeverQrcode(WechatQrcodeForever qrcodeForever) {
        AssertEx.assertNotNullByError((IErrorInfo)new ParamNotNullError("subscriptionId"), (Object)qrcodeForever.getSubscriptionId());
        WechatSubscription wechatSubscription = this.wechatSubscriptionDao.selectByPrimaryKey(qrcodeForever.getSubscriptionId());
        if (wechatSubscription == null) {
            AssertEx.failByError((IErrorInfo)WechatErrors.WECHAT_NOT_FOUND);
        }
        AssertEx.assertNotNullByError((IErrorInfo)new ParamNotNullError("code"), (Object)qrcodeForever.getCode());
        List<WechatQrcodeForever> qrcodeForeverList = this.getPerfectMatchList(qrcodeForever);
        if (qrcodeForeverList != null && qrcodeForeverList.size() > 0) {
            qrcodeForever = qrcodeForeverList.get(0);
        } else {
            String sceneStr;
            String accessToken;
            String qrCodeUrl;
            qrcodeForever.preInsert();
            int flag = this.wechatQrcodeForeverDao.insertSelective(qrcodeForever);
            if (flag == 0) {
                AssertEx.failByError((IErrorInfo)WechatErrors.SAVE_QRCODE_ERROR);
            }
            qrcodeForever = this.getPerfectMatchList(qrcodeForever).get(0);
            BaseWechatBean wechatBean = (BaseWechatBean)SpringContextHolder.getBean((String)("wechatQRCode_" + wechatSubscription.getCode()));
            if (wechatBean == null) {
                AssertEx.failByError((IErrorInfo)WechatErrors.GET_WECHAT_ACCESSTOKEN_BEAN_ERROR);
            }
            if ((qrCodeUrl = WechatUtil.getForeverQrcodeUrl(accessToken = wechatBean.getAccessToken(), sceneStr = WechatUtil.getForeverQrcodeSceneStr(qrcodeForever.getCode(), qrcodeForever.getId().toString()))) == null) {
                AssertEx.failByError((IErrorInfo)WechatErrors.REQUEST_QRCODE_ERROR);
            }
            qrcodeForever.setQrcodeUrl(qrCodeUrl);
            qrcodeForever.getUpdateBy();
            flag = this.wechatQrcodeForeverDao.updateByPrimaryKeySelective(qrcodeForever);
            if (flag == 0) {
                AssertEx.failByError((IErrorInfo)WechatErrors.SAVE_QRCODE_ERROR);
            }
        }
        return this.getPerfectMatchList(qrcodeForever).get(0);
    }

    public WechatQrcodeForever selectByPrimaryKey(Long id) {
        return this.wechatQrcodeForeverDao.selectByPrimaryKey(id);
    }

    public List<WechatQrcodeForever> selectByExample(WechatQrcodeForeverExample example) {
        return this.wechatQrcodeForeverDao.selectByExample(example);
    }
}

