/*
 * Decompiled with CFR 0.152.
 */
package com.cxqm.xiaoerke.wechat.service.impl;

import com.cxqm.xiaoerke.common.bean.IErrorInfo;
import com.cxqm.xiaoerke.common.bean.ParamNotNullError;
import com.cxqm.xiaoerke.common.junit.AssertEx;
import com.cxqm.xiaoerke.common.utils.SpringContextHolder;
import com.cxqm.xiaoerke.wechat.beans.BaseWechatBean;
import com.cxqm.xiaoerke.wechat.beans.WechatErrors;
import com.cxqm.xiaoerke.wechat.dao.WechatQrcodeTempDao;
import com.cxqm.xiaoerke.wechat.dao.WechatSubscriptionDao;
import com.cxqm.xiaoerke.wechat.entity.WechatQrcodeTemp;
import com.cxqm.xiaoerke.wechat.entity.WechatSubscription;
import com.cxqm.xiaoerke.wechat.example.WechatQrcodeTempExample;
import com.cxqm.xiaoerke.wechat.service.WechatQrcodeTempService;
import com.cxqm.xiaoerke.wechat.utils.WechatUtil;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class WechatQrcodeTempServiceImpl
implements WechatQrcodeTempService {
    @Autowired
    private RedisTemplate<String, Object> redisTemplate;
    @Autowired
    WechatQrcodeTempDao wechatQrcodeTempDao;
    @Autowired
    WechatSubscriptionDao wechatSubscriptionDao;

    private List<WechatQrcodeTemp> getPerfectMatchList(WechatQrcodeTemp qrcodeTemp) {
        WechatQrcodeTempExample example = new WechatQrcodeTempExample();
        if (qrcodeTemp != null) {
            WechatQrcodeTempExample.Criteria criteria = example.createCriteria();
            if (qrcodeTemp.getId() != null) {
                criteria.andIdEqualTo(qrcodeTemp.getId());
            }
            if (qrcodeTemp.getCode() != null) {
                criteria.andCodeEqualTo(qrcodeTemp.getCode());
            }
            if (qrcodeTemp.getSubscriptionId() != null) {
                criteria.andSubscriptionIdEqualTo(qrcodeTemp.getSubscriptionId());
            }
            if (qrcodeTemp.getSpare1Str() != null) {
                criteria.andSpare1StrEqualTo(qrcodeTemp.getSpare1Str());
            } else {
                criteria.andSpare1StrIsNull();
            }
            if (qrcodeTemp.getSpare2Str() != null) {
                criteria.andSpare2StrEqualTo(qrcodeTemp.getSpare2Str());
            } else {
                criteria.andSpare2StrIsNull();
            }
            if (qrcodeTemp.getSpare3Str() != null) {
                criteria.andSpare3StrEqualTo(qrcodeTemp.getSpare3Str());
            } else {
                criteria.andSpare3StrIsNull();
            }
            if (qrcodeTemp.getSpare4Str() != null) {
                criteria.andSpare4StrEqualTo(qrcodeTemp.getSpare4Str());
            } else {
                criteria.andSpare4StrIsNull();
            }
            if (qrcodeTemp.getSpare5Str() != null) {
                criteria.andSpare5StrEqualTo(qrcodeTemp.getSpare5Str());
            } else {
                criteria.andSpare5StrIsNull();
            }
            if (qrcodeTemp.getSpare1Num() != null) {
                criteria.andSpare1NumEqualTo(qrcodeTemp.getSpare1Num());
            } else {
                criteria.andSpare1NumIsNull();
            }
            if (qrcodeTemp.getSpare2Num() != null) {
                criteria.andSpare2NumEqualTo(qrcodeTemp.getSpare2Num());
            } else {
                criteria.andSpare2NumIsNull();
            }
            if (qrcodeTemp.getSpare3Num() != null) {
                criteria.andSpare3NumEqualTo(qrcodeTemp.getSpare3Num());
            } else {
                criteria.andSpare3NumIsNull();
            }
            if (qrcodeTemp.getSpare1Date() != null) {
                criteria.andSpare1DateEqualTo(qrcodeTemp.getSpare1Date());
            } else {
                criteria.andSpare1DateIsNull();
            }
            if (qrcodeTemp.getSpare2Date() != null) {
                criteria.andSpare2DateEqualTo(qrcodeTemp.getSpare2Date());
            } else {
                criteria.andSpare2DateIsNull();
            }
            if (qrcodeTemp.getSpare3Date() != null) {
                criteria.andSpare3DateEqualTo(qrcodeTemp.getSpare3Date());
            } else {
                criteria.andSpare3DateIsNull();
            }
        }
        return this.wechatQrcodeTempDao.selectByExample(example);
    }

    public WechatQrcodeTemp createTempQrcode(WechatQrcodeTemp qrcodeTemp) {
        AssertEx.assertNotNullByError((IErrorInfo)new ParamNotNullError("subscriptionId"), (Object)qrcodeTemp.getSubscriptionId());
        WechatSubscription wechatSubscription = this.wechatSubscriptionDao.selectByPrimaryKey(qrcodeTemp.getSubscriptionId());
        if (wechatSubscription == null) {
            AssertEx.failByError((IErrorInfo)WechatErrors.WECHAT_NOT_FOUND);
        }
        AssertEx.assertNotNullByError((IErrorInfo)new ParamNotNullError("code"), (Object)qrcodeTemp.getCode());
        List<WechatQrcodeTemp> qrcodeTempList = this.getPerfectMatchList(qrcodeTemp);
        if (qrcodeTempList != null && qrcodeTempList.size() > 0) {
            WechatQrcodeTemp oldQrcodeTemp = qrcodeTempList.get(0);
            if (qrcodeTemp.getActiveTime() != null) {
                oldQrcodeTemp.setActiveTime(qrcodeTemp.getActiveTime());
            }
            qrcodeTemp = oldQrcodeTemp;
        } else {
            qrcodeTemp.preInsert();
            int falg = this.wechatQrcodeTempDao.insertSelective(qrcodeTemp);
            if (falg == 0) {
                AssertEx.failByError((IErrorInfo)WechatErrors.SAVE_QRCODE_ERROR);
            }
            qrcodeTemp = this.getPerfectMatchList(qrcodeTemp).get(0);
        }
        BaseWechatBean wechatBean = (BaseWechatBean)SpringContextHolder.getBean((String)("wechatQRCode_" + wechatSubscription.getCode()));
        if (wechatBean == null) {
            AssertEx.failByError((IErrorInfo)WechatErrors.GET_WECHAT_ACCESSTOKEN_BEAN_ERROR);
        }
        String accessToken = wechatBean.getAccessToken();
        String sceneStr = WechatUtil.getTempQrcodeSceneStr(qrcodeTemp.getCode(), qrcodeTemp.getId().toString());
        long expireSeconds = 0L;
        if (qrcodeTemp.getActiveTime() != null) {
            long temp = (qrcodeTemp.getActiveTime().getTime() - new Date().getTime()) / 1000L;
            if (temp > 2592000L) {
                AssertEx.failByError((IErrorInfo)WechatErrors.OVER_MAX_ACTIVE_TIME);
            }
            expireSeconds = temp;
        } else {
            Date date = new Date();
            long time = date.getTime();
            date.setTime(time += 900000L);
            qrcodeTemp.setActiveTime(date);
            expireSeconds = 900L;
        }
        String qrCodeUrl = WechatUtil.getTempQrcodeUrl(accessToken, sceneStr, expireSeconds);
        if (qrCodeUrl == null) {
            AssertEx.failByError((IErrorInfo)WechatErrors.REQUEST_QRCODE_ERROR);
        }
        qrcodeTemp.setQrcodeUrl(qrCodeUrl);
        qrcodeTemp.preUpdate();
        int flag = this.wechatQrcodeTempDao.updateByPrimaryKeySelective(qrcodeTemp);
        if (flag == 0) {
            AssertEx.failByError((IErrorInfo)WechatErrors.SAVE_QRCODE_ERROR);
        }
        return this.getPerfectMatchList(qrcodeTemp).get(0);
    }

    public WechatQrcodeTemp selectByPrimaryKey(Long id) {
        return this.wechatQrcodeTempDao.selectByPrimaryKey(id);
    }

    public List<WechatQrcodeTemp> selectByExample(WechatQrcodeTempExample example) {
        return this.wechatQrcodeTempDao.selectByExample(example);
    }

    public RedisTemplate<String, Object> getRedisTemplate() {
        return this.redisTemplate;
    }

    public void setRedisTemplate(RedisTemplate<String, Object> redisTemplate) {
        this.redisTemplate = redisTemplate;
    }

    public WechatQrcodeTempDao getWechatQrcodeTempDao() {
        return this.wechatQrcodeTempDao;
    }

    public void setWechatQrcodeTempDao(WechatQrcodeTempDao wechatQrcodeTempDao) {
        this.wechatQrcodeTempDao = wechatQrcodeTempDao;
    }

    public WechatSubscriptionDao getWechatSubscriptionDao() {
        return this.wechatSubscriptionDao;
    }

    public void setWechatSubscriptionDao(WechatSubscriptionDao wechatSubscriptionDao) {
        this.wechatSubscriptionDao = wechatSubscriptionDao;
    }
}

