/*
 * Decompiled with CFR 0.152.
 */
package com.cxqm.xiaoerke.wechat.utils;

import com.cxqm.xiaoerke.wechat.utils.HttpRequestUtils;
import net.sf.json.JSONObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;

public class WechatUtil {
    public static final int TEMP_QRCODE_EXPIRE_SECONDS_DEFAULT = 900;
    public static final int TEMP_QRCODE_EXPIRE_SECONDS_MAX = 2592000;
    private static Log logger = LogFactory.getLog(WechatUtil.class);
    private static final String CREAT_QRCODE_TICKET = "https://api.weixin.qq.com/cgi-bin/qrcode/create?";
    private static final String GET_QRCODE_BY_TICKET = "https://mp.weixin.qq.com/cgi-bin/showqrcode?";
    public static final String TEMP_QRCODE_SCENE_STR_START = "L";
    public static final String FOREVER_QRCODE_SCENE_STR_START = "C";
    public static final String WECHAT_GET_ACCESSTOKEN_BEAN_START = "wechatQRCode_";
    @Autowired
    private RedisTemplate<String, Object> redisTemplate;

    private static String requestTempQRCodeTicket(String access_token, String scene_str, long expireSeconds) {
        JSONObject myJsonObject = new JSONObject();
        if (access_token != null && !access_token.equals("") && scene_str != null && !scene_str.equals("")) {
            String httpReq = "https://api.weixin.qq.com/cgi-bin/qrcode/create?access_token=" + access_token;
            JSONObject sceneObject = new JSONObject();
            sceneObject.put((Object)"scene_str", (Object)scene_str);
            JSONObject actionInfoObject = new JSONObject();
            actionInfoObject.put((Object)"scene", (Object)sceneObject);
            JSONObject jsonObject = new JSONObject();
            jsonObject.put((Object)"action_name", (Object)"QR_STR_SCENE");
            jsonObject.put((Object)"action_info", (Object)actionInfoObject);
            if (expireSeconds == 0L) {
                expireSeconds = 900L;
            }
            if (expireSeconds > 2592000L) {
                expireSeconds = 2592000L;
            }
            jsonObject.put((Object)"expire_seconds", (Object)expireSeconds);
            String ret = HttpRequestUtils.sendPost(httpReq, jsonObject.toString());
            myJsonObject = JSONObject.fromObject((Object)ret);
            if (myJsonObject.containsKey((Object)"ticket")) {
                String ticket = myJsonObject.getString("ticket");
                if (ticket == null) {
                    System.out.println("\u83b7\u53d6ticket\u5931\u8d25" + ret);
                }
                return ticket;
            }
        } else {
            System.out.println("\u83b7\u53d6ticket\u5931\u8d25\uff1a" + access_token + "," + scene_str);
        }
        return null;
    }

    private static String requestForeverQRCodeTicket(String access_token, String scene_str) {
        JSONObject myJsonObject = new JSONObject();
        if (access_token != null && !access_token.equals("") && scene_str != null && !scene_str.equals("")) {
            String httpReq = "https://api.weixin.qq.com/cgi-bin/qrcode/create?access_token=" + access_token;
            JSONObject sceneObject = new JSONObject();
            sceneObject.put((Object)"scene_str", (Object)scene_str);
            JSONObject actionInfoObject = new JSONObject();
            actionInfoObject.put((Object)"scene", (Object)sceneObject);
            JSONObject jsonObject = new JSONObject();
            jsonObject.put((Object)"action_name", (Object)"QR_LIMIT_STR_SCENE");
            jsonObject.put((Object)"action_info", (Object)actionInfoObject);
            String ret = HttpRequestUtils.sendPost(httpReq, jsonObject.toString());
            myJsonObject = JSONObject.fromObject((Object)ret);
            if (myJsonObject.containsKey((Object)"ticket")) {
                return myJsonObject.getString("ticket");
            }
        }
        return null;
    }

    public static String getForeverQrcodeUrl(String access_token, String scene_str) {
        String ticket = WechatUtil.requestForeverQRCodeTicket(access_token, scene_str);
        if (ticket != null) {
            return "https://mp.weixin.qq.com/cgi-bin/showqrcode?ticket=" + ticket;
        }
        return null;
    }

    public static String getTempQrcodeUrl(String access_token, String scene_str, long expireSeconds) {
        String ticket = WechatUtil.requestTempQRCodeTicket(access_token, scene_str, expireSeconds);
        if (ticket != null) {
            return "https://mp.weixin.qq.com/cgi-bin/showqrcode?ticket=" + ticket;
        }
        return null;
    }

    public static String getTempQrcodeSceneStr(String moduleCode, String primaryKey) {
        StringBuffer sb = new StringBuffer(TEMP_QRCODE_SCENE_STR_START);
        if (primaryKey == null || "".equals(primaryKey.trim())) {
            return null;
        }
        sb.append("_" + primaryKey);
        if (moduleCode != null && !"".equals(moduleCode.trim())) {
            moduleCode = moduleCode.trim();
            sb.append("_" + moduleCode);
        }
        return sb.toString();
    }

    public static String getForeverQrcodeSceneStr(String moduleCode, String primaryKey) {
        StringBuffer sb = new StringBuffer(FOREVER_QRCODE_SCENE_STR_START);
        if (primaryKey == null || "".equals(primaryKey.trim())) {
            return null;
        }
        sb.append("_" + primaryKey);
        if (moduleCode != null && !"".equals(moduleCode.trim())) {
            moduleCode = moduleCode.trim();
            sb.append("_" + moduleCode);
        }
        return sb.toString();
    }
}

