/*
 * Decompiled with CFR 0.152.
 */
package com.cxqm.xiaoerke.wechat.service.impl;

import com.cxqm.xiaoerke.common.bean.IErrorInfo;
import com.cxqm.xiaoerke.common.bean.ParamNotNullError;
import com.cxqm.xiaoerke.common.junit.AssertEx;
import com.cxqm.xiaoerke.common.utils.SpringContextHolder;
import com.cxqm.xiaoerke.wechat.beans.BaseWechatBean;
import com.cxqm.xiaoerke.wechat.beans.WechatErrors;
import com.cxqm.xiaoerke.wechat.dao.WechatQrcodeForeverDao;
import com.cxqm.xiaoerke.wechat.dao.WechatSubscriptionDao;
import com.cxqm.xiaoerke.wechat.entity.WechatQrcodeForever;
import com.cxqm.xiaoerke.wechat.entity.WechatSubscription;
import com.cxqm.xiaoerke.wechat.example.WechatQrcodeForeverExample;
import com.cxqm.xiaoerke.wechat.service.WechatQrcodeForeverService;
import com.cxqm.xiaoerke.wechat.utils.WechatUtil;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WechatQrcodeForeverServiceImpl
implements WechatQrcodeForeverService {
    @Autowired
    WechatQrcodeForeverDao wechatQrcodeForeverDao;
    @Autowired
    WechatSubscriptionDao wechatSubscriptionDao;

    private List<WechatQrcodeForever> getPerfectMatchList(WechatQrcodeForever qrcodeForever) {
        WechatQrcodeForeverExample example = new WechatQrcodeForeverExample();
        if (qrcodeForever != null) {
            if (qrcodeForever.getId() != null) {
                example.createCriteria().andIdEqualTo(qrcodeForever.getId());
            }
            if (qrcodeForever.getCode() != null) {
                example.createCriteria().andCodeEqualTo(qrcodeForever.getCode());
            }
            if (qrcodeForever.getSubscriptionId() != null) {
                example.createCriteria().andSubscriptionIdEqualTo(qrcodeForever.getSubscriptionId());
            }
            if (qrcodeForever.getSpare1Str() != null) {
                example.createCriteria().andSpare1StrEqualTo(qrcodeForever.getSpare1Str());
            } else {
                example.createCriteria().andSpare1StrIsNull();
            }
            if (qrcodeForever.getSpare2Str() != null) {
                example.createCriteria().andSpare2StrEqualTo(qrcodeForever.getSpare2Str());
            } else {
                example.createCriteria().andSpare2StrIsNull();
            }
            if (qrcodeForever.getSpare3Str() != null) {
                example.createCriteria().andSpare3StrEqualTo(qrcodeForever.getSpare3Str());
            } else {
                example.createCriteria().andSpare3StrIsNull();
            }
            if (qrcodeForever.getSpare1Num() != null) {
                example.createCriteria().andSpare1NumEqualTo(qrcodeForever.getSpare1Num());
            } else {
                example.createCriteria().andSpare1NumIsNull();
            }
            if (qrcodeForever.getSpare2Num() != null) {
                example.createCriteria().andSpare2NumEqualTo(qrcodeForever.getSpare2Num());
            } else {
                example.createCriteria().andSpare2NumIsNull();
            }
            if (qrcodeForever.getSpare3Num() != null) {
                example.createCriteria().andSpare3NumEqualTo(qrcodeForever.getSpare3Num());
            } else {
                example.createCriteria().andSpare3NumIsNull();
            }
            if (qrcodeForever.getSpare1Date() != null) {
                example.createCriteria().andSpare1DateEqualTo(qrcodeForever.getSpare1Date());
            } else {
                example.createCriteria().andSpare1DateIsNull();
            }
            if (qrcodeForever.getSpare2Date() != null) {
                example.createCriteria().andSpare2DateEqualTo(qrcodeForever.getSpare2Date());
            } else {
                example.createCriteria().andSpare2DateIsNull();
            }
            if (qrcodeForever.getSpare3Date() != null) {
                example.createCriteria().andSpare3DateEqualTo(qrcodeForever.getSpare3Date());
            } else {
                example.createCriteria().andSpare3DateIsNull();
            }
        }
        return this.wechatQrcodeForeverDao.selectByExample(example);
    }

    public WechatQrcodeForever createForeverQrcode(WechatQrcodeForever qrcodeForever) {
        AssertEx.assertNotNullByError((IErrorInfo)new ParamNotNullError("subscriptionId"), (Object)qrcodeForever.getSubscriptionId());
        WechatSubscription wechatSubscription = this.wechatSubscriptionDao.selectByPrimaryKey(qrcodeForever.getSubscriptionId());
        if (wechatSubscription == null) {
            AssertEx.failByError((IErrorInfo)WechatErrors.WECHAT_NOT_FOUND);
        }
        AssertEx.assertNotNullByError((IErrorInfo)new ParamNotNullError("code"), (Object)qrcodeForever.getCode());
        List<WechatQrcodeForever> qrcodeForeverList = this.getPerfectMatchList(qrcodeForever);
        if (qrcodeForeverList != null && qrcodeForeverList.size() > 0) {
            qrcodeForever = qrcodeForeverList.get(0);
        } else {
            String sceneStr;
            String accessToken;
            String qrCodeUrl;
            qrcodeForever.preInsert();
            int flag = this.wechatQrcodeForeverDao.insertSelective(qrcodeForever);
            if (flag == 0) {
                AssertEx.failByError((IErrorInfo)WechatErrors.SAVE_QRCODE_ERROR);
            }
            qrcodeForever = this.getPerfectMatchList(qrcodeForever).get(0);
            BaseWechatBean wechatBean = (BaseWechatBean)SpringContextHolder.getBean((String)("wechatQRCode_" + wechatSubscription.getCode()));
            if (wechatBean == null) {
                AssertEx.failByError((IErrorInfo)WechatErrors.GET_WECHAT_ACCESSTOKEN_BEAN_ERROR);
            }
            if ((qrCodeUrl = WechatUtil.getForeverQrcodeUrl(accessToken = wechatBean.getAccessToken(), sceneStr = WechatUtil.getForeverQrcodeSceneStr(qrcodeForever.getCode(), qrcodeForever.getId().toString()))) == null) {
                AssertEx.failByError((IErrorInfo)WechatErrors.REQUEST_QRCODE_ERROR);
            }
            qrcodeForever.setQrcodeUrl(qrCodeUrl);
            qrcodeForever.getUpdateBy();
            flag = this.wechatQrcodeForeverDao.updateByPrimaryKeySelective(qrcodeForever);
            if (flag == 0) {
                AssertEx.failByError((IErrorInfo)WechatErrors.SAVE_QRCODE_ERROR);
            }
        }
        return this.getPerfectMatchList(qrcodeForever).get(0);
    }

    public WechatQrcodeForever selectByPrimaryKey(Long id) {
        return this.wechatQrcodeForeverDao.selectByPrimaryKey(id);
    }

    public List<WechatQrcodeForever> selectByExample(WechatQrcodeForeverExample example) {
        return this.wechatQrcodeForeverDao.selectByExample(example);
    }
}

