package com.cxqm.xiaoerke.modules.wechat.activityreward.impl;

import com.alibaba.fastjson.JSONObject;
import com.cxqm.xiaoerke.common.bean.HttpRequestUtilBean;
import com.cxqm.xiaoerke.common.utils.ApiInvokerException;
import com.cxqm.xiaoerke.common.utils.ResponseMapBuilder;
import com.cxqm.xiaoerke.common.web.ApiInvoker;
import com.cxqm.xiaoerke.modules.wechat.activityreward.AngelActivityRewardService;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by sunzb on 2018/7/24.
 */
@Service
public class AngelActivityRewardServiceImpl implements AngelActivityRewardService {

	private ApiInvoker apiInvoker;
	public ApiInvoker getApiInvoker() {
		return apiInvoker;
	}
	public void setApiInvoker(ApiInvoker apiInvoker) {
		this.apiInvoker = apiInvoker;
	}

	/**
	 * sunzb、根据奖励记录id判断奖励是否存在和类型是否正确
	 * @param id 奖励记录id
	 * @return
	 */
	@Override
	public Map<String, Object> queryRewardById(
			String id
	){
		Map<String, String> param = new HashMap<String, String>();
		param.put("id", id);

		HttpRequestUtilBean result = apiInvoker.post("/reward/queryRewardById.do", param);
		JSONObject jsonObject = result.toJSONObject();
		Map returnResult = jsonObject;
		return returnResult;
	}

	/**
	 * sunzb、领取奖励
	 * @param id 奖励记录id
	 * @param userId 用户id
	 * @return
	 */
	@Override
	public Map<String, Object> receiveReward(String id, String userId){

		Map<String, String> param = new HashMap<String, String>();
		param.put("id", id);
		param.put("userId", userId);

		HttpRequestUtilBean result = apiInvoker.post("/reward/receiveReward.do", param);
		JSONObject jsonObject = result.toJSONObject();
		Map returnResult = jsonObject;
		return returnResult;
	}

	/**
	 * sunzb、发放现金奖励
	 * @param price 金额 （单位：分）
	 * @param userId 用户id
	 * @return
	 */
	@Override
	public Map<String, Object> priceReward(String price, String userId, String desc, String rule, String activityType, String chyId, String zhyId, String kjId) {

		Map<String, String> param = new HashMap<String, String>();
		param.put("price", price);
		param.put("userId", userId);

		param.put("desc", desc);
		param.put("rule", rule);
		param.put("activityType", activityType);
		param.put("chyId", chyId);
		param.put("zhyId", zhyId);
		param.put("kjId", kjId);

		apiInvoker.post("/reward/priceReward.do", param);
		return ResponseMapBuilder.newBuilder().putSuccess().getResult();
	}

	/**
	 * sunzb、发放优惠券奖励
	 * @param hospitalId 医院id
	 * @param businessType 模块值
	 * @param price 金额 （单位：分）
	 * @param userId 用户id
	 * @return
	 */
	@Override
	public Map<String, Object> quanReward(String hospitalId, String businessType, String price, String userId, String source, String desc, String rule, String activityType, String chyId, String zhyId, String kjId) {

		Map<String, String> param = new HashMap<String, String>();
		param.put("hospitalId", hospitalId);
		param.put("businessType", businessType);
		param.put("price", price);
		param.put("userId", userId);

		param.put("source", source);
		param.put("desc", desc);
		param.put("rule", rule);
		param.put("activityType", activityType);
		param.put("chyId", chyId);
		param.put("zhyId", zhyId);
		param.put("kjId", kjId);

		apiInvoker.post("/reward/quanReward.do", param);
		return ResponseMapBuilder.newBuilder().putSuccess().getResult();
	}
}
