package com.cxqm.xiaoerke.modules.wechat.push.impl;

import com.alibaba.fastjson.JSONObject;
import com.cxqm.xiaoerke.common.bean.HttpRequestUtilBean;
import com.cxqm.xiaoerke.common.utils.ApiInvokerException;
import com.cxqm.xiaoerke.common.web.ApiInvoker;
import com.cxqm.xiaoerke.modules.wechat.push.AngelWechatPushService;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.Map;

@Service
public class AngelWechatPushServiceImpl implements AngelWechatPushService {

	final static String PUSH_URL = "/wechat/send_wechat.do";
	private ApiInvoker apiInvoker;
	public ApiInvoker getApiInvoker() {
		return apiInvoker;
	}
	public void setApiInvoker(ApiInvoker apiInvoker) {
		this.apiInvoker = apiInvoker;
	}

	@Override
	public void pushByUserId(String user_id, String model_id, String url, String first_text, String keyword1_text, String keyword2_text, String keyword3_text, String remark_text, String first_color, String keyword1_color, String keyword2_color, String keyword3_color, String remark_color) {
		pushByUserId(user_id, model_id, url, first_text, keyword1_text, keyword2_text, keyword3_text, remark_text, first_color, keyword1_color, keyword2_color, keyword3_color, remark_color,null);
	}

	private void pushByUserId(String user_id, String model_id, String url, String first_text, String keyword1_text, String keyword2_text, String keyword3_text, String remark_text, String first_color, String keyword1_color, String keyword2_color, String keyword3_color, String remark_color,String token){
		Map<String, String> param = new HashMap<String, String>();
		param.put("user_id", user_id);
		fillParamMap(param, model_id, url, first_text, keyword1_text, keyword2_text, keyword3_text, remark_text, first_color, keyword1_color, keyword2_color, keyword3_color, remark_color,token);


		HttpRequestUtilBean result = apiInvoker.post(PUSH_URL, param);
		JSONObject jsonObject = result.toJSONObject();
		ApiInvokerException e = apiInvoker.validateResult(jsonObject);
		if (e != null) {
			throw e;
		}
	}
	@Override
	public void pushByUserId(String user_id, String model_id, String url, String first_text, String keyword1_text, String keyword2_text, String keyword3_text, String remark_text) {
		pushByUserId(user_id, model_id, url, first_text, keyword1_text, keyword2_text, keyword3_text, remark_text, null, null, null, null, null);

	}

	@Override
	public void pushByUserId(String user_id,
					  String model_id,
					  String url,
					  String first_text,
					  String keyword1_text,
					  String keyword2_text,
					  String keyword3_text,
					  String remark_text,
					  String token){
		pushByUserId(user_id, model_id, url, first_text, keyword1_text, keyword2_text, keyword3_text, remark_text, null, null, null, null, null,token);
	}

	@Override
	public void pushByPhone(String phone_num, String model_id, String url, String first_text, String keyword1_text, String keyword2_text, String keyword3_text, String remark_text) {
		Map<String, String> param = new HashMap<String, String>();
		param.put("phone_num", phone_num);
		fillParamMap(param, model_id, url, first_text, keyword1_text, keyword2_text, keyword3_text, remark_text, null, null, null, null, null,null);
		HttpRequestUtilBean result = apiInvoker.post(PUSH_URL, param);
		JSONObject jsonObject = result.toJSONObject();
		ApiInvokerException e = apiInvoker.validateResult(jsonObject);
		if (e != null) {
			throw e;
		}
	}

	@Override
	public void pushByOpenId(String open_id, String model_id, String url, String first_text, String keyword1_text, String keyword2_text, String keyword3_text, String remark_text) {
		pushByOpenId(open_id, model_id, url, first_text, keyword1_text, keyword2_text, keyword3_text, remark_text, null, null, null, null, null,null);
	}

	@Override
	public void pushByOpenId(String open_id,
								  String model_id,
								  String url,
								  String first_text,
								  String keyword1_text,
								  String keyword2_text,
								  String keyword3_text,
								  String remark_text,
								  String token){
		pushByOpenId(open_id, model_id, url, first_text, keyword1_text, keyword2_text, keyword3_text, remark_text, null, null, null, null, null,token);
	}

	private void pushByOpenId(String open_id, String model_id, String url, String first_text, String keyword1_text, String keyword2_text, String keyword3_text, String remark_text, String first_color, String keyword1_color, String keyword2_color, String keyword3_color, String remark_color, String token) {
		Map<String, String> param = new HashMap<String, String>();
		param.put("open_id", open_id);
		fillParamMap(param, model_id, url, first_text, keyword1_text, keyword2_text, keyword3_text, remark_text, first_color, keyword1_color, keyword2_color, keyword3_color, remark_color,token);


		HttpRequestUtilBean result = apiInvoker.post(PUSH_URL, param);
		JSONObject jsonObject = result.toJSONObject();
		ApiInvokerException e = apiInvoker.validateResult(jsonObject);
		if (e != null) {
			throw e;
		}
	}

	@Override
	public void pushByOpenId(String open_id, String model_id, String url, String first_text, String keyword1_text, String keyword2_text, String keyword3_text, String remark_text, String first_color, String keyword1_color, String keyword2_color, String keyword3_color, String remark_color) {
		pushByOpenId(open_id, model_id, url, first_text, keyword1_text, keyword2_text, keyword3_text, remark_text, first_color, keyword1_color, keyword2_color, keyword3_color, remark_color,null);
	}

	private void fillParamMap(Map<String, String> param, String model_id, String url, String first_text, String keyword1_text, String keyword2_text, String keyword3_text, String remark_text, String first_color, String keyword1_color, String keyword2_color, String keyword3_color, String remark_color, String token) {
		param.put("model_id", model_id);
		param.put("url", url);
		param.put("first_text", first_text);
		param.put("keyword1_text", keyword1_text);
		param.put("keyword2_text", keyword2_text);
		param.put("keyword3_text", keyword3_text);
		param.put("remark_text", remark_text);

		if (first_color != null) {
			param.put("first_color", first_color);
		}
		if (keyword1_color != null) {
			param.put("keyword1_color", keyword1_color);
		}
		if (keyword2_color != null) {
			param.put("keyword2_color", keyword2_color);
		}
		if (keyword3_color != null) {
			param.put("keyword3_color", keyword3_color);
		}
		if (remark_color != null) {
			param.put("remark_color", remark_color);
		}
		if (token != null){
			param.put("token", token);
		}
	}
}
