/*
 * Decompiled with CFR 0.152.
 */
package com.cxqm.xiaoerke.modules.haoyun.beans;

import com.cxqm.xiaoerke.modules.haoyun.entity.HyConsultationOrder;
import com.cxqm.xiaoerke.modules.haoyun.enums.OrderStatusEnum;
import java.text.SimpleDateFormat;
import java.util.Date;

public class MWebOrderVo {
    private String id;
    private String orderNo;
    private Long orderAmount;
    private Long orderStatus;
    private String orderStatusText;
    private String planDate;
    private String orderDate;
    private String planHospital;
    private String planHospitalId;
    private String requestDoctor;
    private Double payAmount;
    private String planDoctor;
    private String requestHospital;
    private Integer refundStatus;
    private Date refundExamineTime;
    private String refundReanson;
    private Double refundAmount;
    private String userType;

    public MWebOrderVo() {
    }

    public MWebOrderVo(HyConsultationOrder order) {
        if (order == null) {
            return;
        }
        SimpleDateFormat sdf2mm = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        SimpleDateFormat sdf2dd = new SimpleDateFormat("yyyy-MM-dd");
        if (order.getId() != null) {
            this.setId(order.getId());
        }
        if (order.getOrderNo() != null) {
            this.setOrderNo(order.getOrderNo());
        }
        if (order.getOrderAmount() != null) {
            this.setOrderAmount(order.getOrderAmount());
        }
        if (order.getPayAmount() != null) {
            this.setPayAmount(order.getPayAmount());
        }
        if (order.getOrderStatus() != null) {
            this.setOrderStatus(order.getOrderStatus());
            OrderStatusEnum statusEnum = OrderStatusEnum.parseStatus((long)order.getOrderStatus());
            if (statusEnum != null) {
                this.setOrderStatusText(statusEnum.getText());
            }
        }
        if (order.getSubShift() != null && order.getSubShift().getShiftDate() != null) {
            String shiftTime = order.getSubShift().getShiftTime();
            this.setPlanDate(sdf2dd.format(order.getSubShift().getShiftDate()) + (shiftTime == null ? "" : " " + shiftTime));
        }
        if (order.getCommonSource() != null && order.getCommonSource().getSection() != null && order.getCommonSource().getSection().getDate() != null) {
            Date startTime = order.getCommonSource().getSection().getStartTime();
            this.setPlanDate(sdf2dd.format(order.getCommonSource().getSection().getDate()) + (startTime == null ? "" : " " + new SimpleDateFormat("HH:mm").format(startTime)) + "\uff08" + order.getCommonSource().getCode() + "\uff09");
        }
        if (order.getCreateDate() != null) {
            this.setOrderDate(sdf2mm.format(order.getCreateDate()));
        }
        if (order.getCenterHospital() != null) {
            if (order.getCenterHospital().getName() != null) {
                this.setPlanHospital(order.getCenterHospital().getName());
            }
            if (order.getCenterHospital().getId() != null) {
                this.setPlanHospitalId(order.getCenterHospital().getId());
            }
        }
        if (order.getSubDoctorRelation() != null) {
            if (order.getSubDoctorRelation().getDoctorName() != null) {
                this.setRequestDoctor(order.getSubDoctorRelation().getDoctorName());
            }
            if (order.getSubDoctorRelation().getHospitalName() != null) {
                this.setRequestHospital(order.getSubDoctorRelation().getHospitalName());
            }
        }
        if (order.getCenterDoctorRelation() != null && order.getCenterDoctorRelation().getDoctorName() != null) {
            this.setPlanDoctor(order.getCenterDoctorRelation().getDoctorName());
        }
        if (order.getRefundStatus() != null) {
            this.setRefundStatus(order.getRefundStatus());
        } else {
            this.setRefundStatus(0);
        }
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getOrderNo() {
        return this.orderNo;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }

    public Long getOrderAmount() {
        return this.orderAmount;
    }

    public void setOrderAmount(Long orderAmount) {
        this.orderAmount = orderAmount;
    }

    public Long getOrderStatus() {
        return this.orderStatus;
    }

    public void setOrderStatus(Long orderStatus) {
        this.orderStatus = orderStatus;
    }

    public String getOrderStatusText() {
        return this.orderStatusText;
    }

    public void setOrderStatusText(String orderStatusText) {
        this.orderStatusText = orderStatusText;
    }

    public String getPlanDate() {
        return this.planDate;
    }

    public void setPlanDate(String planDate) {
        this.planDate = planDate;
    }

    public String getOrderDate() {
        return this.orderDate;
    }

    public void setOrderDate(String orderDate) {
        this.orderDate = orderDate;
    }

    public String getPlanHospital() {
        return this.planHospital;
    }

    public void setPlanHospital(String planHospital) {
        this.planHospital = planHospital;
    }

    public String getRequestDoctor() {
        return this.requestDoctor;
    }

    public void setRequestDoctor(String requestDoctor) {
        this.requestDoctor = requestDoctor;
    }

    public String getRequestHospital() {
        return this.requestHospital;
    }

    public void setRequestHospital(String requestHospital) {
        this.requestHospital = requestHospital;
    }

    public String getPlanHospitalId() {
        return this.planHospitalId;
    }

    public void setPlanHospitalId(String planHospitalId) {
        this.planHospitalId = planHospitalId;
    }

    public Integer getRefundStatus() {
        return this.refundStatus;
    }

    public void setRefundStatus(Integer refundStatus) {
        this.refundStatus = refundStatus;
    }

    public Date getRefundExamineTime() {
        return this.refundExamineTime;
    }

    public void setRefundExamineTime(Date refundExamineTime) {
        this.refundExamineTime = refundExamineTime;
    }

    public String getRefundReanson() {
        return this.refundReanson;
    }

    public void setRefundReanson(String refundReanson) {
        this.refundReanson = refundReanson;
    }

    public Double getRefundAmount() {
        return this.refundAmount;
    }

    public void setRefundAmount(Double refundAmount) {
        this.refundAmount = refundAmount;
    }

    public String getUserType() {
        return this.userType;
    }

    public void setUserType(String userType) {
        this.userType = userType;
    }

    public String getPlanDoctor() {
        return this.planDoctor;
    }

    public void setPlanDoctor(String planDoctor) {
        this.planDoctor = planDoctor;
    }

    public Double getPayAmount() {
        return this.payAmount;
    }

    public void setPayAmount(Double payAmount) {
        this.payAmount = payAmount;
    }
}

