/*
 * Decompiled with CFR 0.152.
 */
package com.cxqm.xiaoerke.modules.haoyun.beans;

import com.cxqm.xiaoerke.common.config.Global;
import com.cxqm.xiaoerke.modules.haoyun.entity.HyConsultationOrder;
import com.cxqm.xiaoerke.modules.haoyun.entity.HyPatient;
import com.cxqm.xiaoerke.modules.haoyun.enums.ConsultionSourceTypeEnum;
import com.cxqm.xiaoerke.modules.haoyun.enums.OrderStatusEnum;
import com.cxqm.xiaoerke.modules.haoyun.enums.RoomStatusEnum;
import java.text.SimpleDateFormat;
import java.util.Date;

public class ApiOrderVo {
    public static final String ROLE_CENTER_DOCTOR = "10";
    public static final String ROLE_SUB_DOCTOR = "20";
    public static final String ROLE_DOCTOR_HELP = "30";
    public static final String ROLE_OTHER = "40";
    private String id;
    private String orderNo;
    private String status;
    private String statusText;
    private String planDate;
    private String orderDate;
    private String planHospital;
    private String planHospitalId;
    private String contacts;
    private String mobile;
    private String requestDoctor;
    private String requestDoctorId;
    private String requestDoctorHelper;
    private String requestDoctorHelperId;
    private String requestDoctorHelperMobile;
    private String planDoctor;
    private String planDoctorId;
    private String requestHospital;
    private String requestHospitalId;
    private String roomId;
    private Integer roomStatus;
    private String roomStatusText;
    private String roomCreateBy;
    private String roomCreateTime;
    private Integer roomDisabled;
    private String malePatientId;
    private String femalePatientId;
    private String consultationSummary;
    private String proposalName;
    private String proposalRemark;
    private String malePatientName;
    private String femalePatientName;
    private String leftMeetingSecond;
    private String dateName;
    private Integer sourceType;
    private String roleCode;

    public String getDateName() {
        return this.dateName;
    }

    public void setDateName(String dateName) {
        this.dateName = dateName;
    }

    public String getMaleCaseUrl() {
        return HyPatient.getCaseUrl(this.malePatientId);
    }

    public String getFemaleCaseUrl() {
        return HyPatient.getCaseUrl(this.femalePatientId);
    }

    public ApiOrderVo() {
    }

    public String getPlanDoctor() {
        return this.planDoctor;
    }

    public void setPlanDoctor(String planDoctor) {
        this.planDoctor = planDoctor;
    }

    public String getPlanDoctorId() {
        return this.planDoctorId;
    }

    public void setPlanDoctorId(String planDoctorId) {
        this.planDoctorId = planDoctorId;
    }

    public ApiOrderVo(HyConsultationOrder order) {
        if (order == null) {
            return;
        }
        SimpleDateFormat sdf2mm = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        SimpleDateFormat sdf2dd = new SimpleDateFormat("yyyy-MM-dd");
        if (order.getId() != null) {
            this.setId(order.getId());
        }
        if (order.getOrderNo() != null) {
            this.setOrderNo(order.getOrderNo());
        }
        if (order.getOrderStatus() != null) {
            this.setStatus(order.getOrderStatus() + "");
            OrderStatusEnum statusEnum = OrderStatusEnum.parseStatus((long)order.getOrderStatus());
            if (statusEnum != null) {
                this.setStatusText(statusEnum.getText());
            }
        }
        if (order.getSubShift() != null && order.getSubShift().getId() != null) {
            this.setSourceType(ConsultionSourceTypeEnum.VIP_RESOURCE.getValue());
        }
        if (order.getCommonSource() != null && order.getCommonSource() != null) {
            this.setSourceType(ConsultionSourceTypeEnum.COMMON_RESOURCE.getValue());
        }
        if (order.getSubShift() != null && order.getSubShift().getShiftDate() != null) {
            String shiftTime = order.getSubShift().getShiftTime();
            this.setPlanDate(sdf2dd.format(order.getSubShift().getShiftDate()) + (shiftTime == null ? "" : " " + shiftTime));
        }
        if (order.getCommonSource() != null && order.getCommonSource().getSection() != null && order.getCommonSource().getSection().getDate() != null) {
            Date startTime = order.getCommonSource().getSection().getStartTime();
            this.setPlanDate(sdf2dd.format(order.getCommonSource().getSection().getDate()) + (startTime == null ? "" : " " + new SimpleDateFormat("HH:mm").format(startTime)) + "\uff08" + order.getCommonSource().getCode() + "\uff09");
        }
        if (order.getCreateDate() != null) {
            this.setOrderDate(sdf2mm.format(order.getCreateDate()));
        }
        if (order.getCenterHospital() != null) {
            if (order.getCenterHospital().getName() != null) {
                this.setPlanHospital(order.getCenterHospital().getName());
            }
            if (order.getCenterHospital().getId() != null) {
                this.setPlanHospitalId(order.getCenterHospital().getId());
            }
        }
        if (order.getSubDoctorRelation() != null) {
            if (order.getSubDoctorRelation().getSysDoctorId() != null) {
                this.setRequestDoctorId(order.getSubDoctorRelation().getSysDoctorId());
            }
            if (order.getSubDoctorRelation().getSysHospitalId() != null) {
                this.setRequestHospitalId(order.getSubDoctorRelation().getSysHospitalId());
            }
            if (order.getSubDoctorRelation().getDoctorName() != null) {
                this.setRequestDoctor(order.getSubDoctorRelation().getDoctorName());
            }
            if (order.getSubDoctorRelation().getHospitalName() != null) {
                this.setRequestHospital(order.getSubDoctorRelation().getHospitalName());
            }
        }
        if (order.getCenterDoctorRelation() != null) {
            if (order.getCenterDoctorRelation().getSysDoctorId() != null) {
                this.setPlanDoctorId(order.getCenterDoctorRelation().getSysDoctorId());
            }
            if (order.getCenterDoctorRelation().getDoctorName() != null) {
                this.setPlanDoctor(order.getCenterDoctorRelation().getDoctorName());
            }
        }
        if (order.getName() != null) {
            this.setContacts(order.getUser().getName());
        }
        if (order.getMobile() != null) {
            this.setMobile(order.getUser().getMobile());
        }
        if (order.getRoomStatus() != null) {
            this.setRoomStatus(order.getRoomStatus());
            RoomStatusEnum em = RoomStatusEnum.parseStatus(this.getRoomStatus());
            if (em != null) {
                this.setRoomStatusText(em.getText());
            }
        }
        if (order.getRoomId() != null) {
            this.setRoomId(order.getRoomId());
        }
        if (order.getRoomId() != null) {
            this.setRoomId(order.getRoomId());
        }
        if (order.getRoomCreateBy() != null) {
            this.setRoomCreateBy(order.getRoomCreateBy());
        }
        if (order.getRoomCreateTime() != null) {
            this.setRoomCreateTime(sdf2mm.format(order.getRoomCreateTime()));
        }
        if (order.getMalePatient() != null && order.getMalePatient().getId() != null) {
            this.setMalePatientId(order.getMalePatient().getId());
            this.setMalePatientName(order.getMalePatient().getName());
        }
        if (order.getFemalePatient() != null && order.getFemalePatient().getId() != null) {
            this.setFemalePatientId(order.getFemalePatient().getId());
            this.setFemalePatientName(order.getFemalePatient().getName());
        }
        if (order.getConsultationSummary() != null) {
            this.setConsultationSummary(order.getConsultationSummary());
        }
        if (order.getProposalRemark() != null) {
            this.setProposalRemark(order.getProposalRemark());
        }
        if (order.getProposalName() != null) {
            this.setProposalName(order.getProposalName());
        }
        if (order.getDateName() != null) {
            this.setDateName(order.getDateName());
        }
        this.setRoomDisabled(order.getRoomIsDisabled() ? 1 : 0);
        Long leftMeetingSecondNum = (long)Global.getMeetingExpiredSecond().intValue() - (order.getMeetingSecond() == null ? 0L : order.getMeetingSecond());
        this.setLeftMeetingSecond(leftMeetingSecondNum + "");
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getOrderNo() {
        return this.orderNo;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatusText() {
        return this.statusText;
    }

    public void setStatusText(String statusText) {
        this.statusText = statusText;
    }

    public String getPlanDate() {
        return this.planDate;
    }

    public void setPlanDate(String planDate) {
        this.planDate = planDate;
    }

    public String getOrderDate() {
        return this.orderDate;
    }

    public void setOrderDate(String orderDate) {
        this.orderDate = orderDate;
    }

    public String getPlanHospital() {
        return this.planHospital;
    }

    public void setPlanHospital(String planHospital) {
        this.planHospital = planHospital;
    }

    public String getContacts() {
        return this.contacts;
    }

    public void setContacts(String contacts) {
        this.contacts = contacts;
    }

    public String getMobile() {
        return this.mobile;
    }

    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    public String getRequestDoctor() {
        return this.requestDoctor;
    }

    public void setRequestDoctor(String requestDoctor) {
        this.requestDoctor = requestDoctor;
    }

    public String getRequestHospital() {
        return this.requestHospital;
    }

    public void setRequestHospital(String requestHospital) {
        this.requestHospital = requestHospital;
    }

    public String getRoomId() {
        return this.roomId;
    }

    public void setRoomId(String roomId) {
        this.roomId = roomId;
    }

    public String getRoomCreateBy() {
        return this.roomCreateBy;
    }

    public void setRoomCreateBy(String roomCreateBy) {
        this.roomCreateBy = roomCreateBy;
    }

    public String getRoomCreateTime() {
        return this.roomCreateTime;
    }

    public void setRoomCreateTime(String roomCreateTime) {
        this.roomCreateTime = roomCreateTime;
    }

    public Integer getRoomStatus() {
        return this.roomStatus;
    }

    public void setRoomStatus(Integer roomStatus) {
        this.roomStatus = roomStatus;
    }

    public String getRoomStatusText() {
        return this.roomStatusText;
    }

    public void setRoomStatusText(String roomStatusText) {
        this.roomStatusText = roomStatusText;
    }

    public Integer getRoomDisabled() {
        return this.roomDisabled;
    }

    public void setRoomDisabled(Integer roomDisabled) {
        this.roomDisabled = roomDisabled;
    }

    public String getMalePatientId() {
        return this.malePatientId;
    }

    public void setMalePatientId(String malePatientId) {
        this.malePatientId = malePatientId;
    }

    public String getFemalePatientId() {
        return this.femalePatientId;
    }

    public void setFemalePatientId(String femalePatientId) {
        this.femalePatientId = femalePatientId;
    }

    public String getPlanHospitalId() {
        return this.planHospitalId;
    }

    public void setPlanHospitalId(String planHospitalId) {
        this.planHospitalId = planHospitalId;
    }

    public String getRequestDoctorId() {
        return this.requestDoctorId;
    }

    public void setRequestDoctorId(String requestDoctorId) {
        this.requestDoctorId = requestDoctorId;
    }

    public String getRequestHospitalId() {
        return this.requestHospitalId;
    }

    public void setRequestHospitalId(String requestHospitalId) {
        this.requestHospitalId = requestHospitalId;
    }

    public String getRoleCode() {
        return this.roleCode;
    }

    public void setRoleCode(String roleCode) {
        this.roleCode = roleCode;
    }

    public String getConsultationSummary() {
        return this.consultationSummary;
    }

    public void setConsultationSummary(String consultationSummary) {
        this.consultationSummary = consultationSummary;
    }

    public String getProposalRemark() {
        return this.proposalRemark;
    }

    public void setProposalRemark(String proposalRemark) {
        this.proposalRemark = proposalRemark;
    }

    public String getMalePatientName() {
        return this.malePatientName;
    }

    public void setMalePatientName(String malePatientName) {
        this.malePatientName = malePatientName;
    }

    public String getFemalePatientName() {
        return this.femalePatientName;
    }

    public void setFemalePatientName(String femalePatientName) {
        this.femalePatientName = femalePatientName;
    }

    public String getProposalName() {
        return this.proposalName;
    }

    public void setProposalName(String proposalName) {
        this.proposalName = proposalName;
    }

    public String getLeftMeetingSecond() {
        return this.leftMeetingSecond;
    }

    public void setLeftMeetingSecond(String leftMeetingSecond) {
        this.leftMeetingSecond = leftMeetingSecond;
    }

    public Integer getSourceType() {
        return this.sourceType;
    }

    public void setSourceType(Integer sourceType) {
        this.sourceType = sourceType;
    }

    public String getRequestDoctorHelper() {
        return this.requestDoctorHelper;
    }

    public void setRequestDoctorHelper(String requestDoctorHelper) {
        this.requestDoctorHelper = requestDoctorHelper;
    }

    public String getRequestDoctorHelperId() {
        return this.requestDoctorHelperId;
    }

    public void setRequestDoctorHelperId(String requestDoctorHelperId) {
        this.requestDoctorHelperId = requestDoctorHelperId;
    }

    public String getRequestDoctorHelperMobile() {
        return this.requestDoctorHelperMobile;
    }

    public void setRequestDoctorHelperMobile(String requestDoctorHelperMobile) {
        this.requestDoctorHelperMobile = requestDoctorHelperMobile;
    }
}

