/*
 * Decompiled with CFR 0.152.
 */
package com.cxqm.xiaoerke.modules.haoyun.event.listener;

import com.cxqm.xiaoerke.modules.consult.entity.Message;
import com.cxqm.xiaoerke.modules.consult.event.UnReadEvent;
import com.cxqm.xiaoerke.modules.haoyun.service.HyWechatPushService;
import com.cxqm.xiaoerke.modules.push.service.PushNetService;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class UnReadEventMessageListener
implements ApplicationListener<UnReadEvent> {
    @Autowired
    PushNetService pushNetService;
    @Autowired
    HyWechatPushService hyWechatPushService;
    SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    @Async
    public void onApplicationEvent(UnReadEvent unReadEvent) {
        Message msg = (Message)unReadEvent.getSource();
        if ("user".equals(msg.getSendusertype())) {
            this.pushUserToDocter(msg);
        } else if ("doctor".equals(msg.getSendusertype())) {
            this.pushDocterToUser(msg);
        }
    }

    private void pushUserToDocter(Message msg) {
        HashMap<String, String> dictionary = new HashMap<String, String>();
        dictionary.put("openurl", msg.getOpenurl());
        this.pushNetService.push(msg.getUserId(), "ios", null, null, null, dictionary, msg.getPushcount(), "graphicconsult", msg.getSendname() + "\uff1a" + msg.getEscapeMsgImg());
    }

    private void pushDocterToUser(Message msg) {
        this.hyWechatPushService.pushWechat(msg.getUserId(), msg.getSendname(), this.formatter.format(new Date()), msg.getEscapeMsgImg(), msg.getOpenurl());
    }
}

