/*
 * Decompiled with CFR 0.152.
 */
package com.cxqm.xiaoerke.modules.haoyun.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.cxqm.xiaoerke.common.utils.IdGen;
import com.cxqm.xiaoerke.modules.haoyun.service.HyApiUserSession;
import com.cxqm.xiaoerke.modules.sys.entity.User;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=false)
public class HyApiUserSessionImpl
implements HyApiUserSession {
    private static final String HYZS_API_SID2JSON_KEY = "hyzs.api.sid2user.";
    private static final String HYZS_API_UID2SID_KEY = "hyzs.api.uid2sid.";
    @Autowired
    private RedisTemplate<String, Object> redisTemplate;

    public User getUser(String sid) {
        String jsonstr4user = (String)this.redisTemplate.opsForValue().get((Object)(HYZS_API_SID2JSON_KEY + sid));
        JSONObject jsonObject = null;
        try {
            jsonObject = JSON.parseObject((String)jsonstr4user);
        }
        catch (Exception e) {
            this.removeSid2Json(sid);
            e.printStackTrace();
            return null;
        }
        User user = this.json2User(jsonObject);
        if (user == null || user.getId() == null) {
            this.removeSid2Json(sid);
            return null;
        }
        String sidInRedis = this.getSid(user.getId());
        if (sidInRedis == null || !sidInRedis.equals(sid)) {
            this.removeSid2Json(sid);
            this.removeUid2Sid(user.getId());
            return null;
        }
        return user;
    }

    public String setUser(User user) {
        return this.setUser(null, user);
    }

    public String setUser(String sid, User user) {
        if (user == null) {
            return null;
        }
        if (user.getId() == null) {
            return null;
        }
        if (sid == null) {
            sid = IdGen.uuid();
        }
        JSONObject jo = this.user2Json(user);
        String oldSid = this.getSid(user.getId());
        this.removeSid2Json(oldSid);
        this.redisTemplate.opsForValue().set((Object)(HYZS_API_UID2SID_KEY + user.getId()), (Object)sid);
        this.redisTemplate.opsForValue().set((Object)(HYZS_API_SID2JSON_KEY + sid), (Object)jo.toJSONString());
        return sid;
    }

    public void removeSidWithUser(String sid) {
        User user = this.getUser(sid);
        if (user == null) {
            return;
        }
        this.removeSid2Json(sid);
        if (user.getId() == null) {
            return;
        }
        this.removeUid2Sid(user.getId());
    }

    private void removeSid2Json(String sid) {
        this.redisTemplate.delete((Object)(HYZS_API_SID2JSON_KEY + sid));
    }

    private void removeUid2Sid(String uid) {
        this.redisTemplate.delete((Object)(HYZS_API_UID2SID_KEY + uid));
    }

    private String getSid(String uid) {
        String sid = (String)this.redisTemplate.opsForValue().get((Object)(HYZS_API_UID2SID_KEY + uid));
        return sid;
    }

    private JSONObject user2Json(User user) {
        if (user == null) {
            return null;
        }
        JSONObject jo = new JSONObject();
        jo.put("id", (Object)user.getId());
        jo.put("name", (Object)user.getName());
        jo.put("loginName", (Object)user.getLoginName());
        jo.put("buckter", (Object)user.getBuckter());
        jo.put("photo", (Object)user.getPhoto());
        jo.put("userType", (Object)user.getUserType());
        jo.put("sex", (Object)user.getSex());
        jo.put("loginDate", (Object)new Date().getTime());
        return jo;
    }

    private User json2User(JSONObject jsonObject) {
        if (jsonObject == null) {
            return null;
        }
        String id = jsonObject.getString("id");
        String name = jsonObject.getString("name");
        String loginName = jsonObject.getString("loginName");
        String buckter = jsonObject.getString("buckter");
        String photo = jsonObject.getString("photo");
        String userType = jsonObject.getString("userType");
        Integer sex = jsonObject.getInteger("sex");
        Long loginDate = jsonObject.getLong("loginDate");
        User user = new User();
        user.setId(id);
        user.setName(name);
        user.setLoginName(loginName);
        user.setBuckter(buckter);
        user.setPhoto(photo);
        user.setUserType(userType);
        user.setSex(sex);
        if (loginDate != null) {
            user.setLoginDate(new Date(loginDate));
        }
        return user;
    }
}

