/*
 * Decompiled with CFR 0.152.
 */
package com.cxqm.xiaoerke.modules.haoyun.service.impl;

import com.cxqm.xiaoerke.common.filter.MUserInfo;
import com.cxqm.xiaoerke.common.junit.AssertEx;
import com.cxqm.xiaoerke.common.persistence.Page;
import com.cxqm.xiaoerke.common.utils.IdGen;
import com.cxqm.xiaoerke.modules.haoyun.beans.InviteRecordCondition;
import com.cxqm.xiaoerke.modules.haoyun.beans.InviteRecordVo;
import com.cxqm.xiaoerke.modules.haoyun.dao.InviteRecordDao;
import com.cxqm.xiaoerke.modules.haoyun.entity.InviteRecord;
import com.cxqm.xiaoerke.modules.haoyun.service.InviteRecordService;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class InviteRecordServiceImpl
implements InviteRecordService {
    @Autowired
    private InviteRecordDao inviteRecordDao;

    private void insert(InviteRecord inviteRecord) {
        this.inviteRecordDao.insertSelective(inviteRecord);
    }

    public Page<InviteRecordCondition> getGiveInvitePageByUserId(Page<InviteRecordCondition> page, String userId) {
        InviteRecordCondition inviteRecordCondition = new InviteRecordCondition();
        inviteRecordCondition.setInviteUserId(userId);
        return this.inviteRecordDao.getGiveInvitePageByUserId(page, inviteRecordCondition);
    }

    public Page<InviteRecordCondition> getReceiveInvitePageByUserId(Page<InviteRecordCondition> page, String userId) {
        InviteRecordCondition inviteRecordCondition = new InviteRecordCondition();
        inviteRecordCondition.setBeenInviteUserId(userId);
        return this.inviteRecordDao.getReceiveInvitePageByUserId(page, inviteRecordCondition);
    }

    public void save(InviteRecord inviteRecord) {
        inviteRecord.setId(IdGen.vestaId());
        inviteRecord.setCreateBy(MUserInfo.getUserInfoValue());
        inviteRecord.setCreateDate(new Date());
        inviteRecord.setDelFlag("0");
        this.insert(inviteRecord);
    }

    public List<InviteRecordVo> packageInviteRecordVoList(List<InviteRecordCondition> inviteRecordConditions) {
        ArrayList<InviteRecordVo> list = new ArrayList<InviteRecordVo>();
        for (InviteRecordCondition condition : inviteRecordConditions) {
            InviteRecordVo vo = new InviteRecordVo();
            vo.setId(condition.getId());
            vo.setBeenInvitePhone(condition.getBeenInviteLoginName());
            vo.setBeenInviteUserName(condition.getBeenInviteUserName());
            vo.setInviteUserName(condition.getInviteUserName());
            vo.setInviteUserPhone(condition.getInviteUserPhone());
            vo.setCreateDate(condition.getCreateDate());
            list.add(vo);
        }
        return list;
    }

    public List<InviteRecordCondition> getInviter(String invitaId) {
        AssertEx.assertNotNull((Object)invitaId);
        InviteRecordCondition condition = new InviteRecordCondition();
        condition.setId(invitaId);
        return this.inviteRecordDao.selectInviterCondition(condition);
    }

    public InviteRecord getInviterById(String invitaId) {
        List<InviteRecord> list = this.getInviteRecordList(invitaId);
        if (list == null || list.size() == 0) {
            return null;
        }
        return list.get(0);
    }

    private List<InviteRecord> getInviteRecordList(String invitaId) {
        InviteRecordCondition condition = new InviteRecordCondition();
        condition.setId(invitaId);
        List<InviteRecord> inviteRecords = this.inviteRecordDao.selectInviter((InviteRecord)condition);
        if (inviteRecords == null || inviteRecords.size() == 0) {
            return null;
        }
        return inviteRecords;
    }

    public InviteRecord getInviter(String uid, String module, String userType) {
        AssertEx.assertNotNull((Object)uid);
        InviteRecordCondition condition = new InviteRecordCondition();
        condition.setBeenInviteUserId(uid);
        condition.setInviteUserType(userType);
        condition.setModule(module);
        List<InviteRecord> inviteRecords = this.inviteRecordDao.selectInviter((InviteRecord)condition);
        if (inviteRecords == null || inviteRecords.size() == 0) {
            return null;
        }
        return inviteRecords.get(0);
    }
}

