/*
 * Decompiled with CFR 0.152.
 */
package com.cxqm.xiaoerke.modules.haoyun.service.impl;

import com.cxqm.xiaoerke.modules.haoyun.dao.KjActivityDao;
import com.cxqm.xiaoerke.modules.haoyun.dao.KjInvitationDao;
import com.cxqm.xiaoerke.modules.haoyun.entity.KjActivity;
import com.cxqm.xiaoerke.modules.haoyun.entity.KjInvitation;
import com.cxqm.xiaoerke.modules.haoyun.enums.KjHuoDongEnum;
import com.cxqm.xiaoerke.modules.haoyun.enums.KjInvitationStatusEnum;
import com.cxqm.xiaoerke.modules.haoyun.example.KjInvitationExample;
import com.cxqm.xiaoerke.modules.haoyun.service.KjActivityService;
import com.cxqm.xiaoerke.modules.haoyun.service.KjInvitationService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class KjInvitationServiceImpl
implements KjInvitationService {
    boolean strictCheck = false;
    @Autowired
    KjInvitationDao kjInvitationDao;
    @Autowired
    KjActivityDao kjActivityDao;
    @Autowired
    KjActivityService kjActivityService;

    public void save(KjInvitation kjInvitation) {
        this.kjInvitationDao.insertSelective(kjInvitation);
    }

    public KjInvitation selectById(String kjActivityId, String userId) {
        KjInvitationExample kjInvitationExample = new KjInvitationExample();
        kjInvitationExample.createCriteria().andActivityIdEqualTo(kjActivityId).andUseridEqualTo(userId);
        List<KjInvitation> kjInvitations = this.kjInvitationDao.selectByExample(kjInvitationExample);
        if (kjInvitations == null || kjInvitations.size() <= 0) {
            return null;
        }
        return kjInvitations.get(0);
    }

    public KjInvitation selectByInvitationId(String InvitationId) {
        return this.kjInvitationDao.selectByPrimaryKey(InvitationId);
    }

    public KjHuoDongEnum checkInvalid(KjInvitation kjInvitation) {
        KjActivity kjActivity;
        KjHuoDongEnum status;
        if (kjInvitation == null) {
            return KjHuoDongEnum.INVITATION_NULL;
        }
        if (kjInvitation.getStatus() != null && KjInvitationStatusEnum.START.getValue() != kjInvitation.getStatus()) {
            return KjHuoDongEnum.INVITATION_STATUS;
        }
        Long time = System.currentTimeMillis() - kjInvitation.getCreateDate().getTime();
        if (time != null) {
            time = time / 1000L;
        }
        if (time > kjInvitation.getTotalTime()) {
            return KjHuoDongEnum.INVITATION_TIMEOUT;
        }
        if (kjInvitation.getBargainCount() == kjInvitation.getTotalCount()) {
            return KjHuoDongEnum.INVITATION_FINISH;
        }
        if (this.strictCheck && (status = this.kjActivityService.checkInvalid(kjActivity = this.kjActivityDao.selectByPrimaryKey(kjInvitation.getActivityId()))) != KjHuoDongEnum.EFFECTIVE) {
            return status;
        }
        return KjHuoDongEnum.EFFECTIVE;
    }

    public void update(KjInvitation kjInvitation) {
        this.kjInvitationDao.updateByPrimaryKeySelective(kjInvitation);
    }
}

