/*
 * Decompiled with CFR 0.152.
 */
package com.cxqm.xiaoerke.modules.haoyun.queue;

import com.cxqm.xiaoerke.common.queue.RedisQueueListener;
import com.cxqm.xiaoerke.modules.haoyun.service.HyWechatPushService;
import com.cxqm.xiaoerke.modules.haoyun.util.HaoYunWechatMsgUtils;
import com.cxqm.xiaoerke.modules.sys.beans.HaoYunWechatMsg;
import com.cxqm.xiaoerke.modules.sys.beans.PushWechatMsg;
import com.cxqm.xiaoerke.modules.sys.entity.User;
import com.cxqm.xiaoerke.modules.sys.service.UserInfoService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class AngelWechatPushIsFiveMinutBackQueueListener
implements RedisQueueListener<PushWechatMsg> {
    Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private HyWechatPushService hyWechatPushService;
    @Autowired
    private UserInfoService userInfoService;

    public void onMessage(PushWechatMsg value) {
        if (value != null && value.getUserId() != null && this.hyWechatPushService.isFiveMinutBack(value.getUserId())) {
            try {
                this.logger.info("[\u6dfb\u52a0\u5fae\u4fe1\u63a8\u9001]\u5f00\u59cb\u4fdd\u5b58redis...");
                this.hyWechatPushService.savePushRedisFiveMinutWithin(value.getUserId());
                this.logger.info("[\u6dfb\u52a0\u5fae\u4fe1\u63a8\u9001]\u4fdd\u5b58redis\u5b8c\u6210");
                User user = this.userInfoService.getUserById(value.getUserId());
                this.logger.info("\u653e\u5165\u5fae\u4fe1\u63a8\u9001\u961f\u5217 openid" + user.getOpenid());
                HaoYunWechatMsg haoYunWechatMsg = new HaoYunWechatMsg(user.getOpenid(), value.getUrl(), "\u60a8\u6536\u5230\u4e00\u6761\u6765\u81ea\u533b\u751f\u7684\u56de\u590d", "", value.getFromName(), "", value.getMsgTime(), "", "\u56fe\u6587\u54a8\u8be2\u56de\u590d", "", value.getMessage(), "#0000ff", value.getTemplateId());
                HaoYunWechatMsgUtils.pushToPublicQueue(haoYunWechatMsg);
            }
            catch (Throwable throwable) {
                this.logger.error("\u6dfb\u52a0\u5fae\u4fe1\u63a8\u9001\u961f\u5217\u5931\u8d25", throwable);
            }
        }
    }
}

