/*
 * Decompiled with CFR 0.152.
 */
package com.cxqm.xiaoerke.modules.haoyun.service.impl;

import com.cxqm.xiaoerke.modules.haoyun.beans.FamilyPatient;
import com.cxqm.xiaoerke.modules.haoyun.beans.HyMedicalHistoryCondition;
import com.cxqm.xiaoerke.modules.haoyun.dao.HyMedicalHistoryDao;
import com.cxqm.xiaoerke.modules.haoyun.entity.HyMedicalHistory;
import com.cxqm.xiaoerke.modules.haoyun.service.HyMedicalHistoryService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class HyMedicalHistoryServiceImpl
implements HyMedicalHistoryService {
    @Autowired
    private HyMedicalHistoryDao hyMedicalHistoryDao;

    public FamilyPatient<HyMedicalHistory> findFamilyMedicalHistory(String maleId, String femaleId) {
        if (maleId == null && femaleId == null) {
            return null;
        }
        ArrayList<String> idIn = new ArrayList<String>();
        if (maleId != null) {
            idIn.add(maleId);
        }
        if (femaleId != null) {
            idIn.add(femaleId);
        }
        HyMedicalHistoryCondition condition = new HyMedicalHistoryCondition();
        condition.setPatientIdIn(idIn);
        List<HyMedicalHistory> list = this.hyMedicalHistoryDao.selectListByCondition(condition);
        if (list == null || list.size() == 0) {
            return null;
        }
        FamilyPatient result = new FamilyPatient();
        for (HyMedicalHistory hyMedicalHistory : list) {
            if (maleId != null && maleId.equals(hyMedicalHistory.getPatient().getId())) {
                result.setMale((Object)hyMedicalHistory);
            }
            if (femaleId == null || !femaleId.equals(hyMedicalHistory.getPatient().getId())) continue;
            result.setFemale((Object)hyMedicalHistory);
        }
        return result;
    }

    public void insert(HyMedicalHistory hyMedicalHistory) {
        this.hyMedicalHistoryDao.insert(hyMedicalHistory);
    }

    public void update(HyMedicalHistory hyMedicalHistory) {
        this.hyMedicalHistoryDao.updateByPrimaryKey(hyMedicalHistory);
    }

    public HyMedicalHistory findMedicalHistory(String patientId) {
        if (patientId == null) {
            return null;
        }
        HyMedicalHistoryCondition condition = new HyMedicalHistoryCondition();
        condition.setPatientIdIn(Arrays.asList(patientId));
        List<HyMedicalHistory> list = this.hyMedicalHistoryDao.selectListByCondition(condition);
        if (list == null || list.size() == 0) {
            return null;
        }
        return list.get(0);
    }

    public HyMedicalHistory findMedicalHistoryById(String recordId) {
        if (recordId == null) {
            return null;
        }
        return this.hyMedicalHistoryDao.selectByPrimaryKey(recordId);
    }
}

