/*
 * Decompiled with CFR 0.152.
 */
package com.cxqm.xiaoerke.modules.haoyun.service.impl;

import com.cxqm.xiaoerke.common.persistence.Page;
import com.cxqm.xiaoerke.modules.haoyun.beans.HyProjectHistoryCondition;
import com.cxqm.xiaoerke.modules.haoyun.beans.ProjectPackageVo;
import com.cxqm.xiaoerke.modules.haoyun.dao.HyProjectHistoryDao;
import com.cxqm.xiaoerke.modules.haoyun.entity.HyProjectHistory;
import com.cxqm.xiaoerke.modules.haoyun.service.HyProjectHistoryService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class HyProjectHistoryServiceImpl
implements HyProjectHistoryService {
    @Autowired
    private HyProjectHistoryDao hyProjectHistoryDao;

    public List<ProjectPackageVo> findListByCondition(HyProjectHistoryCondition condition) {
        List<HyProjectHistory> hyProjectHistoryList = this.hyProjectHistoryDao.selectListByCondition(condition);
        HashMap historyMap = new HashMap();
        if (hyProjectHistoryList == null || hyProjectHistoryList.size() == 0) {
            return null;
        }
        for (HyProjectHistory hyProjectHistory : hyProjectHistoryList) {
            if (historyMap.containsKey(hyProjectHistory.getProjectCode())) {
                ((List)historyMap.get(hyProjectHistory.getProjectCode())).add(hyProjectHistory);
                continue;
            }
            ArrayList<HyProjectHistory> tempList = new ArrayList<HyProjectHistory>();
            tempList.add(hyProjectHistory);
            historyMap.put(hyProjectHistory.getProjectCode(), tempList);
        }
        ArrayList<ProjectPackageVo> voList = new ArrayList<ProjectPackageVo>();
        Iterator iterator = historyMap.keySet().iterator();
        while (iterator.hasNext()) {
            ProjectPackageVo vo = new ProjectPackageVo();
            String key = (String)iterator.next();
            vo.setProjectCode(key);
            vo.setProjectHistoryList((List)historyMap.get(key));
            voList.add(vo);
        }
        return voList;
    }

    public void insert(HyProjectHistory hyProjectHistory) {
        if (hyProjectHistory == null) {
            return;
        }
        this.hyProjectHistoryDao.insert(hyProjectHistory);
    }

    public HyProjectHistory findLatestByProjectCode(String projectCode) {
        HyProjectHistoryCondition condition = new HyProjectHistoryCondition();
        condition.setProjectCode(projectCode);
        condition.setOrderByCondition(" latest_version  desc ,upload_time desc,create_date desc ");
        List<HyProjectHistory> hyProjectHistoryList = this.hyProjectHistoryDao.selectListByCondition(condition);
        HyProjectHistory hyProjectHistory = new HyProjectHistory();
        if (hyProjectHistoryList != null && hyProjectHistoryList.size() > 0) {
            hyProjectHistory = hyProjectHistoryList.get(0);
        }
        return hyProjectHistory;
    }

    public HyProjectHistory findProjectHistoryById(String recordId) {
        if (recordId == null) {
            return null;
        }
        HyProjectHistoryCondition condition = new HyProjectHistoryCondition();
        condition.setId(recordId);
        List<HyProjectHistory> list = this.hyProjectHistoryDao.selectListByCondition(condition);
        if (list == null || list.size() == 0) {
            return null;
        }
        return list.get(0);
    }

    public void update(HyProjectHistory hyProjectHistory) {
        this.hyProjectHistoryDao.updateByPrimaryKeySelective(hyProjectHistory);
    }

    public int del(String recordId) {
        this.hyProjectHistoryDao.deleteByPrimaryKey(recordId);
        return this.hyProjectHistoryDao.deleteByPrimaryKey(recordId);
    }

    public Page<HyProjectHistory> findAppVersionList(Page<HyProjectHistory> page, HyProjectHistory hyProjectHistory) {
        Page<HyProjectHistory> list = this.hyProjectHistoryDao.findAppVersionByProjectCodeOrByUploadTime(page, hyProjectHistory);
        return list;
    }

    public List<HyProjectHistory> findProjectCode() {
        return this.hyProjectHistoryDao.findProjectCode();
    }
}

