/*
 * Decompiled with CFR 0.152.
 */
package com.cxqm.xiaoerke.modules.haoyun.service.impl;

import com.cxqm.xiaoerke.common.filter.MUserInfo;
import com.cxqm.xiaoerke.common.junit.AssertEx;
import com.cxqm.xiaoerke.common.persistence.Page;
import com.cxqm.xiaoerke.common.utils.IdGen;
import com.cxqm.xiaoerke.modules.haoyun.beans.InviteRecordCondition;
import com.cxqm.xiaoerke.modules.haoyun.beans.InviteRecordVo;
import com.cxqm.xiaoerke.modules.haoyun.dao.InviteRecordDao;
import com.cxqm.xiaoerke.modules.haoyun.entity.InviteRecord;
import com.cxqm.xiaoerke.modules.haoyun.example.InviteRecordExample;
import com.cxqm.xiaoerke.modules.haoyun.service.InviteRecordService;
import com.cxqm.xiaoerke.modules.sys.entity.User;
import com.cxqm.xiaoerke.modules.sys.service.UserInfoService;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class InviteRecordServiceImpl
implements InviteRecordService {
    @Autowired
    private InviteRecordDao inviteRecordDao;
    @Autowired
    private UserInfoService userInfoService;

    private void insert(InviteRecord inviteRecord) {
        this.inviteRecordDao.insertSelective(inviteRecord);
    }

    public Integer getDoctorZhySuccessInsureNum(String userId) {
        InviteRecordCondition condition = new InviteRecordCondition();
        condition.setInviteUserId(userId);
        Integer num = this.inviteRecordDao.getDoctorZhySuccessInsureNum(condition);
        if (num == null) {
            return 0;
        }
        return num;
    }

    public Page<InviteRecordCondition> getDoctorZhyInviteRecord(Page<InviteRecordCondition> page, String userId) {
        InviteRecordCondition inviteRecordCondition = new InviteRecordCondition();
        inviteRecordCondition.setInviteUserId(userId);
        inviteRecordCondition.setModule("bx");
        inviteRecordCondition.setInviteUserType("doctor");
        return this.inviteRecordDao.getGiveInvitePageByUserId(page, inviteRecordCondition);
    }

    public void updateInviteRecordInsureStatus(String beenInviteUserId, String module, String userType, String status) {
        User user = this.userInfoService.getUserById(beenInviteUserId);
        if (user == null || user.getOpenid() == null || user.getOpenid().trim().equals("")) {
            return;
        }
        InviteRecordCondition condition = new InviteRecordCondition();
        condition.setBeenInviteUserOpenid(user.getOpenid());
        condition.setModule(module);
        condition.setInviteUserType(userType);
        InviteRecord inviteRecord = this.inviteRecordDao.selectEarlierTimeRecordByBeenInviteOpenid(condition);
        if (inviteRecord == null) {
            return;
        }
        inviteRecord.setWhetherInsure(status);
        this.inviteRecordDao.updateByPrimaryKeySelective(inviteRecord);
    }

    public Page<InviteRecordCondition> getGiveInvitePageByUserId(Page<InviteRecordCondition> page, String userId) {
        InviteRecordCondition inviteRecordCondition = new InviteRecordCondition();
        inviteRecordCondition.setInviteUserId(userId);
        inviteRecordCondition.setModule("bx");
        inviteRecordCondition.setInviteUserType("user");
        return this.inviteRecordDao.getGiveInvitePageByUserId(page, inviteRecordCondition);
    }

    public List<InviteRecordCondition> getReceiveInvitePageByUserId(Page<InviteRecordCondition> page, String userId) {
        InviteRecordCondition inviteRecordCondition = new InviteRecordCondition();
        inviteRecordCondition.setBeenInviteUserId(userId);
        inviteRecordCondition.setModule("bx");
        inviteRecordCondition.setInviteUserType("user");
        Page<InviteRecordCondition> inviteRecordPage = this.inviteRecordDao.getReceiveInvitePageByUserId(page, inviteRecordCondition);
        if (inviteRecordPage == null || inviteRecordPage.getList() == null || inviteRecordPage.getList().size() == 0) {
            return null;
        }
        List list = inviteRecordPage.getList();
        ArrayList<InviteRecordCondition> new_list = new ArrayList<InviteRecordCondition>();
        if (list.get(0) == null) {
            return null;
        }
        new_list.add((InviteRecordCondition)list.get(0));
        return new_list;
    }

    public void save(InviteRecord inviteRecord) {
        inviteRecord.setId(IdGen.vestaId());
        inviteRecord.setCreateBy(MUserInfo.getUserInfoValue());
        inviteRecord.setCreateDate(new Date());
        inviteRecord.setDelFlag("0");
        this.insert(inviteRecord);
    }

    public List<InviteRecordVo> packageInviteRecordVoList(List<InviteRecordCondition> inviteRecordConditions) {
        if (inviteRecordConditions == null || inviteRecordConditions.size() == 0) {
            return null;
        }
        ArrayList<InviteRecordVo> list = new ArrayList<InviteRecordVo>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        for (InviteRecordCondition condition : inviteRecordConditions) {
            InviteRecordVo vo = new InviteRecordVo();
            vo.setId(condition.getId());
            vo.setBeenInvitePhone(condition.getBeenInviteLoginName());
            vo.setBeenInviteUserName(condition.getBeenInviteUserName());
            vo.setInviteUserName(condition.getInviteUserName());
            vo.setInviteUserPhone(condition.getInviteUserPhone());
            vo.setCreateDate(sdf.format(condition.getCreateDate()));
            vo.setPrice(Integer.valueOf(condition.getPrice() == null ? 0 : condition.getPrice()));
            vo.setWhetherInsure(condition.getWhetherInsure() == null ? null : condition.getWhetherInsure());
            vo.setDoctorWhetherReceiveReward(Integer.valueOf(condition.getDoctorWhetherReceiveReward() == null ? 0 : condition.getDoctorWhetherReceiveReward()));
            vo.setUserWhetherReceiveReward(Integer.valueOf(condition.getUserWhetherReceiveReward() == null ? 0 : condition.getUserWhetherReceiveReward()));
            list.add(vo);
        }
        return list;
    }

    public List<InviteRecordCondition> getInviter(String invitaId) {
        AssertEx.assertNotNull((Object)invitaId);
        InviteRecordCondition condition = new InviteRecordCondition();
        condition.setId(invitaId);
        return this.inviteRecordDao.selectInviterCondition(condition);
    }

    public InviteRecord getInviterById(String invitaId) {
        List<InviteRecord> list = this.getInviteRecordList(invitaId);
        if (list == null || list.size() == 0) {
            return null;
        }
        return list.get(0);
    }

    private List<InviteRecord> getInviteRecordList(String invitaId) {
        InviteRecordCondition condition = new InviteRecordCondition();
        condition.setId(invitaId);
        List<InviteRecord> inviteRecords = this.inviteRecordDao.selectInviter((InviteRecord)condition);
        if (inviteRecords == null || inviteRecords.size() == 0) {
            return null;
        }
        return inviteRecords;
    }

    public InviteRecord getInviter(String uid, String module, String userType) {
        AssertEx.assertNotNull((Object)uid);
        InviteRecordCondition condition = new InviteRecordCondition();
        condition.setBeenInviteUserId(uid);
        condition.setInviteUserType(userType);
        condition.setModule(module);
        List<InviteRecord> inviteRecords = this.inviteRecordDao.selectInviter((InviteRecord)condition);
        if (inviteRecords == null || inviteRecords.size() == 0) {
            return null;
        }
        return inviteRecords.get(0);
    }

    public Integer getInviteNumByInviterId(String inviteId, String bx, String userType) {
        InviteRecordExample inviteRecordExample = new InviteRecordExample();
        inviteRecordExample.createCriteria().andInviteUserIdEqualTo(inviteId).andModuleEqualTo(bx).andInviteUserTypeEqualTo(userType);
        List<InviteRecord> list = this.query(inviteRecordExample);
        if (list == null || list.size() == 0) {
            return 0;
        }
        return list.size();
    }

    private List<InviteRecord> query(InviteRecordExample inviteRecordExample) {
        List<InviteRecord> list = this.inviteRecordDao.selectByExample(inviteRecordExample);
        return list;
    }

    public List<InviteRecordCondition> getInviteListByInviterId(String inviteId, String module, String userType) {
        return this.inviteRecordDao.getInviteListByInviterId(inviteId, module, userType);
    }
}

