/*
 * Decompiled with CFR 0.152.
 */
package com.cxqm.xiaoerke.modules.haoyun.service.impl;

import com.cxqm.xiaoerke.common.bean.BusinessException;
import com.cxqm.xiaoerke.common.bean.IErrorInfo;
import com.cxqm.xiaoerke.common.bean.ParamNotNullError;
import com.cxqm.xiaoerke.common.junit.AssertEx;
import com.cxqm.xiaoerke.common.persistence.Page;
import com.cxqm.xiaoerke.common.utils.IdGen;
import com.cxqm.xiaoerke.modules.haoyun.beans.HaoyunErrors;
import com.cxqm.xiaoerke.modules.haoyun.beans.UserCondition;
import com.cxqm.xiaoerke.modules.haoyun.dao.SysUserFollowDao;
import com.cxqm.xiaoerke.modules.haoyun.entity.SysUserFollow;
import com.cxqm.xiaoerke.modules.haoyun.example.SysUserFollowExample;
import com.cxqm.xiaoerke.modules.haoyun.service.SysUserFollowService;
import com.cxqm.xiaoerke.modules.sys.entity.User;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SysUserFollowServiceImpl
implements SysUserFollowService {
    @Autowired
    private SysUserFollowDao sysUserFollowDao;

    public User findAFollowUser(Integer pageNo, Integer pageSize, Integer currentSize, String userId) {
        Page<User> user = null;
        if (pageSize > currentSize) {
            user = this.sysUserFollowDao.findFollowUser((Page<User>)new Page(pageNo.intValue(), pageSize.intValue()), new UserCondition(userId));
            if (user == null || user.getList() == null || user.getList().size() == 0 || user.getList().size() <= currentSize) {
                return null;
            }
            return (User)user.getList().get(currentSize - 1);
        }
        user = this.sysUserFollowDao.findFollowUser((Page<User>)new Page(pageNo + 1, pageSize.intValue()), new UserCondition(userId));
        if (user == null || user.getList() == null || user.getList().size() == 0) {
            return null;
        }
        return (User)user.getList().get(0);
    }

    public void cancelFollowByOfFollowUserId(String ofFollowUserId, String currentUserId) {
        this.deleteSysUserFollow(ofFollowUserId, currentUserId);
    }

    public Page<User> findFollowUser(Page<User> page, String userId, String notFindUserId) {
        if (userId == null || userId.trim().equals("")) {
            return null;
        }
        UserCondition userCondition = new UserCondition(userId);
        if (notFindUserId != null) {
            userCondition.setNotFindUserId(notFindUserId.split(","));
        }
        return this.sysUserFollowDao.findFollowUser(page, userCondition);
    }

    public Page<User> findFollowUser(Page<User> page, String userId) {
        if (userId == null || userId.trim().equals("")) {
            return null;
        }
        return this.sysUserFollowDao.findFollowUser(page, new UserCondition(userId));
    }

    public Map findIsFollow(String followUserId, String currentUserId, boolean isQueryFollow) {
        this.validateSysUserFollow(followUserId, currentUserId);
        return this.findOrDeleteFollowByIsQueryFollow(followUserId, currentUserId, isQueryFollow);
    }

    private Map findOrDeleteFollowByIsQueryFollow(String followUserId, String currentUserId, boolean isQueryFollow) {
        this.validateSysUserFollow(followUserId, currentUserId);
        HashMap<String, Object> map = new HashMap<String, Object>();
        SysUserFollow sysUserFollow = this.findSysUserFollow(followUserId, currentUserId);
        if (isQueryFollow) {
            if (sysUserFollow == null) {
                map.put("displayMsg", "\u5173\u6ce8");
                map.put("showFollow", true);
                return map;
            }
            map.put("displayMsg", "\u53d6\u6d88\u5173\u6ce8");
            map.put("showFollow", false);
            return map;
        }
        if (sysUserFollow == null) {
            if (this.saveSysUserFollow(followUserId, currentUserId) == 1) {
                map.put("promptMsg", "\u5173\u6ce8\u6210\u529f!");
                map.put("displayMsg", "\u53d6\u6d88\u5173\u6ce8");
                map.put("showFollow", false);
                return map;
            }
            throw new BusinessException((IErrorInfo)HaoyunErrors.FOLLOW_FAILED);
        }
        if (this.deleteSysUserFollow(sysUserFollow) == 1) {
            map.put("promptMsg", "\u53d6\u6d88\u5173\u6ce8\u6210\u529f!");
            map.put("displayMsg", "\u5173\u6ce8");
            map.put("showFollow", true);
            return map;
        }
        throw new BusinessException((IErrorInfo)HaoyunErrors.CANCEL_FOLLOW_FAILED);
    }

    private int saveSysUserFollow(String followUserId, String currentUserId) {
        this.validateSysUserFollow(followUserId, currentUserId);
        SysUserFollow sysUserFollow = new SysUserFollow();
        sysUserFollow.setId(IdGen.vestaId());
        sysUserFollow.setOfSysUser(new User(followUserId));
        sysUserFollow.setSysUser(new User(currentUserId));
        sysUserFollow.setCreateBy(new User(currentUserId));
        return this.sysUserFollowDao.insertSelective(sysUserFollow);
    }

    private int deleteSysUserFollow(SysUserFollow sysUserFollow) {
        if (sysUserFollow == null) {
            return 0;
        }
        return this.sysUserFollowDao.deleteByPrimaryKey(sysUserFollow.getId());
    }

    private int deleteSysUserFollow(String followUserId, String currentUserId) {
        SysUserFollowExample sysUserFollowExample = new SysUserFollowExample();
        AssertEx.assertNotNullByError((IErrorInfo)new ParamNotNullError("followUserId"), (Object)followUserId);
        AssertEx.assertNotNullByError((IErrorInfo)new ParamNotNullError("currentUserId"), (Object)currentUserId);
        sysUserFollowExample.createCriteria().andSysUserEqualTo(new User(currentUserId)).andOfSysUserEqualTo(new User(followUserId));
        return this.sysUserFollowDao.deleteByExample(sysUserFollowExample);
    }

    private SysUserFollow findSysUserFollow(String followUserId, String currentUserId) {
        this.validateSysUserFollow(followUserId, currentUserId);
        SysUserFollowExample sysUserFollowExample = new SysUserFollowExample();
        sysUserFollowExample.createCriteria().andSysUserEqualTo(new User(currentUserId)).andOfSysUserEqualTo(new User(followUserId));
        List<SysUserFollow> list = this.sysUserFollowDao.selectByExample(sysUserFollowExample);
        if (list == null || list.size() == 0) {
            return null;
        }
        return list.get(0);
    }

    private void validateSysUserFollow(String followUserId, String currentUserId) {
        AssertEx.assertNotNullByError((IErrorInfo)new ParamNotNullError("followUserId"), (Object)followUserId);
        AssertEx.assertNotNullByError((IErrorInfo)new ParamNotNullError("currentUserId"), (Object)currentUserId);
    }
}

