/*
 * Decompiled with CFR 0.152.
 */
package com.cxqm.xiaoerke.modules.haoyun.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.cxqm.xiaoerke.common.filter.MUserInfo;
import com.cxqm.xiaoerke.common.utils.MD5UtilNew;
import com.cxqm.xiaoerke.modules.sys.entity.WechatUserInfo;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.NoSuchAlgorithmException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class HuodongUserInfo {
    public static String COOKIEPK = "X1+n3$]`N8~/";
    public static String COOKIE_USERINFO_KEY = "haoyun_huodong_userInfo";
    public static String COOKIE_VERSION_KEY = "haoyun_huodong_version";
    public static String COOKIE_USERINFO_TOKEN_KEY = "haoyun_huodong_userInfo_token";
    public static Integer COOKIE_VERSION = 4;
    public static final String THREAD_CURRENT_WEIXIN_USER = "HUODONG_CURRENT_WEIXIN_USER";

    public static WechatUserInfo getUserFromCookie(HttpServletRequest request) throws UnsupportedEncodingException, NoSuchAlgorithmException {
        String userCookieStr;
        String tokenOri;
        String token;
        request.setCharacterEncoding("utf-8");
        Cookie[] cookies = request.getCookies();
        WechatUserInfo userEntity = null;
        String userCookie = null;
        String userHiddenCookie = null;
        Integer versionCookie = null;
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (COOKIE_USERINFO_KEY.equals(cookie.getName())) {
                    userCookie = URLDecoder.decode(cookie.getValue(), "UTF-8");
                }
                if (COOKIE_USERINFO_TOKEN_KEY.equals(cookie.getName())) {
                    userHiddenCookie = URLDecoder.decode(cookie.getValue(), "UTF-8");
                }
                if (!COOKIE_VERSION_KEY.equals(cookie.getName())) continue;
                versionCookie = Integer.valueOf(cookie.getValue());
            }
        }
        if (userCookie != null && (token = MD5UtilNew.getMD5String((String)(tokenOri = (userCookieStr = String.valueOf(userCookie)) + COOKIEPK))).equals(userHiddenCookie) && versionCookie == COOKIE_VERSION) {
            JSONObject json = JSON.parseObject((String)userCookieStr);
            userEntity = HuodongUserInfo.getPackagingUserCookie(json);
        }
        return userEntity;
    }

    public static WechatUserInfo getPackagingUserCookie(JSONObject jsonObject) {
        WechatUserInfo userInfo = (WechatUserInfo)JSON.parseObject((String)jsonObject.toJSONString(), WechatUserInfo.class);
        return userInfo;
    }

    public static WechatUserInfo getCurrent() {
        return (WechatUserInfo)MUserInfo.getValue((String)THREAD_CURRENT_WEIXIN_USER);
    }

    public static void setCurrent(WechatUserInfo user) throws UnsupportedEncodingException, NoSuchAlgorithmException {
        MUserInfo.setValue((String)THREAD_CURRENT_WEIXIN_USER, (Object)user);
    }

    public static void responseCookie(HttpServletRequest request, HttpServletResponse response, WechatUserInfo user) throws UnsupportedEncodingException, NoSuchAlgorithmException, JsonProcessingException {
        if (user == null || response == null) {
            return;
        }
        HuodongUserInfo.setCurrent(user);
        HuodongUserInfo.setCurrentUserToCookie(user, request, response);
    }

    private static void setCurrentUserToCookie(WechatUserInfo user, HttpServletRequest request, HttpServletResponse response) throws UnsupportedEncodingException, NoSuchAlgorithmException, JsonProcessingException {
        String[] domainArr = request.getServerName().split("\\.");
        String doamin = "";
        doamin = domainArr.length == 1 || domainArr[domainArr.length - 1].matches("\\d*") ? request.getServerName() : "." + domainArr[domainArr.length - 2] + "." + domainArr[domainArr.length - 1];
        JSONObject userCookie = HuodongUserInfo.packagingUserCookie(user);
        Cookie cookie = new Cookie(COOKIE_USERINFO_KEY, URLEncoder.encode(String.valueOf(userCookie), "UTF-8"));
        cookie.setMaxAge(Integer.MAX_VALUE);
        cookie.setPath("/");
        cookie.setDomain(doamin);
        response.addCookie(cookie);
        String userCookieStr = String.valueOf(userCookie);
        String tokenOri = userCookieStr + COOKIEPK;
        String token = MD5UtilNew.getMD5String((String)tokenOri);
        Cookie cookieToken = new Cookie(COOKIE_USERINFO_TOKEN_KEY, token);
        cookieToken.setMaxAge(Integer.MAX_VALUE);
        cookieToken.setPath("/");
        cookieToken.setDomain(doamin);
        response.addCookie(cookieToken);
        Cookie cookieVersion = new Cookie(COOKIE_VERSION_KEY, COOKIE_VERSION.toString());
        cookieVersion.setMaxAge(Integer.MAX_VALUE);
        cookieVersion.setPath("/");
        cookieVersion.setDomain(doamin);
        response.addCookie(cookieVersion);
    }

    public static JSONObject packagingUserCookie(WechatUserInfo user) {
        JSONObject result = null;
        try {
            result = (JSONObject)JSON.toJSON((Object)user);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }
}

