/*
 * Decompiled with CFR 0.152.
 */
package com.cxqm.xiaoerke.modules.haoyun.web;

import com.cxqm.xiaoerke.common.utils.SpringContextHolder;
import com.cxqm.xiaoerke.modules.sys.entity.User;
import com.cxqm.xiaoerke.modules.sys.service.UserInfoService;
import java.util.HashMap;

public class ApiUserInfo {
    private static ThreadLocal<HashMap<String, Object>> threadLocals = new ThreadLocal();
    public static final String CURRENT_API_USER = "CURRENT_API_USER";
    public static final String CURRENT_USER_FULL_LOADED = "CURRENT_USER_FULL_LOADED";

    public static boolean isUserFullLoaded() {
        Boolean loaded = (Boolean)ApiUserInfo.getValue(CURRENT_USER_FULL_LOADED);
        if (loaded == null) {
            return false;
        }
        return loaded;
    }

    private static void setUserFullLoaded(boolean loaded) {
        ApiUserInfo.setValue(CURRENT_USER_FULL_LOADED, loaded);
    }

    public static String getUserId() {
        User user = (User)ApiUserInfo.getValue(CURRENT_API_USER);
        if (user == null) {
            return null;
        }
        return user.getId();
    }

    public static User getUser() {
        User user = (User)ApiUserInfo.getValue(CURRENT_API_USER);
        if (user == null) {
            return null;
        }
        if (user.getId() == null) {
            return null;
        }
        if (!ApiUserInfo.isUserFullLoaded()) {
            UserInfoService userService = (UserInfoService)SpringContextHolder.getBean(UserInfoService.class);
            if (userService == null) {
                return null;
            }
            User userInDb = userService.getUserById(user.getId());
            ApiUserInfo.setUserFullLoaded(true);
            if (userInDb != null) {
                user = userInDb;
                ApiUserInfo.setValue(CURRENT_API_USER, userInDb);
            }
        }
        return user;
    }

    public static void setUser(User user) {
        ApiUserInfo.setValue(CURRENT_API_USER, user);
    }

    public static void setUserId(String userId) {
        ApiUserInfo.clearUser();
        if (userId == null) {
            return;
        }
        User user = new User();
        user.setId(userId);
        ApiUserInfo.setValue(CURRENT_API_USER, user);
    }

    public static void clearUser() {
        ApiUserInfo.removeValue(CURRENT_API_USER);
        ApiUserInfo.removeValue(CURRENT_USER_FULL_LOADED);
    }

    public static Object getValue(String name) {
        if (threadLocals.get() == null) {
            threadLocals.set(new HashMap());
        }
        return threadLocals.get().get(name);
    }

    public static void setValue(String name, Object value) {
        if (threadLocals.get() == null) {
            threadLocals.set(new HashMap());
        }
        threadLocals.get().put(name, value);
    }

    public static void removeValue(String name) {
        if (threadLocals.get() == null) {
            return;
        }
        threadLocals.get().remove(name);
    }

    public static void clear() {
        if (threadLocals.get() != null) {
            threadLocals.get().clear();
        }
    }
}

