/*
 * Decompiled with CFR 0.152.
 */
package com.cxqm.xiaoerke.modules.haoyun.service.impl;

import com.cxqm.xiaoerke.common.persistence.Page;
import com.cxqm.xiaoerke.common.utils.IdGen;
import com.cxqm.xiaoerke.modules.haoyun.beans.CaseMaterialJsonVo;
import com.cxqm.xiaoerke.modules.haoyun.beans.CasePackageVo;
import com.cxqm.xiaoerke.modules.haoyun.beans.FamilyPatient;
import com.cxqm.xiaoerke.modules.haoyun.beans.HyCaseGroupByAnalysisInfo;
import com.cxqm.xiaoerke.modules.haoyun.beans.HyCaseGroupByCreator;
import com.cxqm.xiaoerke.modules.haoyun.beans.HyCaseMaterialCondition;
import com.cxqm.xiaoerke.modules.haoyun.beans.MaterialGroupVo;
import com.cxqm.xiaoerke.modules.haoyun.beans.MaterialPackageVo;
import com.cxqm.xiaoerke.modules.haoyun.dao.HyCaseMaterialDao;
import com.cxqm.xiaoerke.modules.haoyun.dao.HyCaseMaterialHeadDao;
import com.cxqm.xiaoerke.modules.haoyun.dao.HyCaseSubCategoryDao;
import com.cxqm.xiaoerke.modules.haoyun.dao.HyCaseTopCategoryDao;
import com.cxqm.xiaoerke.modules.haoyun.entity.HyCaseMaterial;
import com.cxqm.xiaoerke.modules.haoyun.entity.HyCaseMaterialHead;
import com.cxqm.xiaoerke.modules.haoyun.entity.HyCaseSubCategory;
import com.cxqm.xiaoerke.modules.haoyun.entity.HyCaseTopCategory;
import com.cxqm.xiaoerke.modules.haoyun.entity.HyGravidityHistory;
import com.cxqm.xiaoerke.modules.haoyun.entity.HyMedicalHistory;
import com.cxqm.xiaoerke.modules.haoyun.entity.HyPatient;
import com.cxqm.xiaoerke.modules.haoyun.enums.SexEnum;
import com.cxqm.xiaoerke.modules.haoyun.service.HyCaseMaterialService;
import com.cxqm.xiaoerke.modules.haoyun.service.HyGravidityHistoryService;
import com.cxqm.xiaoerke.modules.haoyun.service.HyMedicalHistoryService;
import com.cxqm.xiaoerke.modules.haoyun.service.HyPatientService;
import com.cxqm.xiaoerke.modules.sys.entity.User;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class HyCaseMaterialServiceImpl
implements HyCaseMaterialService {
    @Autowired
    HyCaseMaterialDao hyCaseMaterialDao;
    @Autowired
    HyPatientService hyPatientService;
    @Autowired
    HyGravidityHistoryService hyGravidityHistoryService;
    @Autowired
    HyMedicalHistoryService hyMedicalHistoryService;
    @Autowired
    private HyCaseSubCategoryDao hyCaseSubCategoryDao;
    @Autowired
    private HyCaseTopCategoryDao hyCaseTopCategoryDao;
    @Autowired
    private HyCaseMaterialHeadDao hyCaseMaterialHeadDao;

    public FamilyPatient<List<MaterialPackageVo>> findFamilyMaterial(String maleId, String femaleId, String showAllCategory) {
        FamilyPatient result = new FamilyPatient();
        if (maleId == null && femaleId == null) {
            return result;
        }
        ArrayList<String> patientIds = new ArrayList<String>();
        if (maleId != null) {
            patientIds.add(maleId);
        }
        if (femaleId != null) {
            patientIds.add(femaleId);
        }
        HyCaseMaterialCondition condition = new HyCaseMaterialCondition();
        condition.setPatientIdIn(patientIds);
        List<HyCaseMaterial> list = this.hyCaseMaterialDao.selectByCondition(condition);
        ArrayList<HyCaseMaterial> males = new ArrayList<HyCaseMaterial>();
        ArrayList<HyCaseMaterial> females = new ArrayList<HyCaseMaterial>();
        for (HyCaseMaterial hyCaseMaterial : list) {
            if (maleId != null && hyCaseMaterial.getPatient().getId().equals(maleId)) {
                males.add(hyCaseMaterial);
            }
            if (femaleId == null || !hyCaseMaterial.getPatient().getId().equals(femaleId)) continue;
            females.add(hyCaseMaterial);
        }
        HyCaseTopCategory malesCondition = new HyCaseTopCategory();
        malesCondition.setSex(Integer.valueOf(SexEnum.MALE.getValue()));
        HyCaseTopCategory femalesCondition = new HyCaseTopCategory();
        femalesCondition.setSex(Integer.valueOf(SexEnum.FEMALE.getValue()));
        List<MaterialPackageVo> malePackage = null;
        List<MaterialPackageVo> femalePackage = null;
        if (showAllCategory != null && showAllCategory.equals("1")) {
            malePackage = this.formatMaterialPackageWithAllCategory(males, malesCondition);
            femalePackage = this.formatMaterialPackageWithAllCategory(females, femalesCondition);
        } else {
            malePackage = this.formatMaterialPackage(males);
            femalePackage = this.formatMaterialPackage(females);
        }
        result.setMale(malePackage);
        result.setFemale(femalePackage);
        return result;
    }

    public Boolean updateCaseMaterialsByJsonVoList(String patientId, String userId, List<CaseMaterialJsonVo> caseMaterialJsonVos) {
        if (patientId == null || userId == null) {
            return false;
        }
        ArrayList<HyCaseMaterial> caseMaterials = new ArrayList<HyCaseMaterial>();
        if (caseMaterialJsonVos != null && caseMaterialJsonVos.size() > 0) {
            HyCaseSubCategory condition = new HyCaseSubCategory();
            condition.setOrderby("0000");
            List<HyCaseSubCategory> hyCaseSubCategorys = this.hyCaseSubCategoryDao.selectListByCondition(condition);
            HashMap<String, HyCaseSubCategory> hyCaseSubCategoryMap = new HashMap<String, HyCaseSubCategory>();
            if (hyCaseSubCategorys != null && hyCaseSubCategorys.size() > 0) {
                for (HyCaseSubCategory caseSubCategory : hyCaseSubCategorys) {
                    hyCaseSubCategoryMap.put(caseSubCategory.getTopCategory().getId(), caseSubCategory);
                }
            }
            HyPatient patient = new HyPatient();
            patient.setId(patientId);
            for (CaseMaterialJsonVo vo : caseMaterialJsonVos) {
                HyCaseSubCategory temp;
                HyCaseSubCategory caseSubCategory = new HyCaseSubCategory();
                if (vo.getCaseSubCategoryId() != null && !vo.getCaseSubCategoryId().equals("")) {
                    caseSubCategory.setId(vo.getCaseSubCategoryId());
                } else if (vo.getCaseTopCategoryId() != null && !vo.getCaseTopCategoryId().equals("") && hyCaseSubCategoryMap.containsKey(vo.getCaseTopCategoryId()) && (temp = (HyCaseSubCategory)hyCaseSubCategoryMap.get(vo.getCaseTopCategoryId())) != null && temp.getId() != null) {
                    caseSubCategory.setId(temp.getId());
                }
                HyCaseMaterial caseMaterial = new HyCaseMaterial();
                caseMaterial.setPatient(patient);
                caseMaterial.setCategory(caseSubCategory);
                caseMaterial.setId(vo.getId() == null ? null : vo.getId());
                caseMaterial.setBucket(vo.getBucket() == null ? null : vo.getBucket());
                caseMaterial.setAnalysisDate(vo.getAnalysisDate() == null ? null : vo.getAnalysisDate());
                caseMaterial.setAnalysisHospital(vo.getAnalysisHospital() == null ? null : vo.getAnalysisHospital());
                caseMaterial.setContent(vo.getContent() == null ? null : vo.getContent());
                caseMaterial.setName(vo.getName() == null ? null : vo.getName());
                caseMaterial.setOrderby(vo.getOrderby() == null ? null : vo.getOrderby());
                caseMaterial.setPic(vo.getPic() == null ? null : vo.getPic());
                caseMaterial.setRemarks(vo.getRemarks() == null ? null : vo.getRemarks());
                caseMaterial.setCaseMaterialHeadId(vo.getCaseMaterialHeadId() == null ? null : vo.getCaseMaterialHeadId());
                caseMaterial.setOrderId(vo.getOrderId() == null ? null : vo.getOrderId());
                caseMaterials.add(caseMaterial);
            }
        }
        return this.updateCaseMaterials(patientId, userId, caseMaterials);
    }

    public Boolean updateCaseMaterials(String patientId, String userId, List<HyCaseMaterial> newCaseMaterials) {
        block11: {
            ArrayList<String> headIds;
            User user;
            List<HyCaseMaterial> historyCaseMaterials;
            block10: {
                if (patientId == null || userId == null) {
                    return false;
                }
                historyCaseMaterials = this.findCaseMaterials(patientId);
                user = new User();
                user.setId(userId);
                headIds = null;
                if (newCaseMaterials != null && newCaseMaterials.size() != 0) break block10;
                if (historyCaseMaterials == null || historyCaseMaterials.size() < 0) break block11;
                for (HyCaseMaterial caseMaterial : historyCaseMaterials) {
                    caseMaterial.setDelFlag("1");
                    caseMaterial.setUpdateBy(user);
                    caseMaterial.setUpdateDate(new Date());
                    this.hyCaseMaterialDao.updateByPrimaryKey(caseMaterial);
                    if (caseMaterial.getCaseMaterialHeadId() == null || caseMaterial.getCaseMaterialHeadId().trim().equals("")) continue;
                    headIds = new ArrayList<String>();
                    headIds.add(caseMaterial.getCaseMaterialHeadId());
                    HyCaseMaterialCondition condition = new HyCaseMaterialCondition();
                    condition.setHeadIds(headIds);
                    List<HyCaseMaterial> list = this.hyCaseMaterialDao.selectByCondition(condition);
                    if (list != null && list.size() != 0) continue;
                    this.hyCaseMaterialHeadDao.deleteByPrimaryKey(caseMaterial.getCaseMaterialHeadId());
                }
                break block11;
            }
            HashMap<String, HyCaseMaterial> historyMap = new HashMap<String, HyCaseMaterial>();
            if (historyCaseMaterials != null && historyCaseMaterials.size() > 0) {
                for (HyCaseMaterial caseMaterial : historyCaseMaterials) {
                    historyMap.put(caseMaterial.getId(), caseMaterial);
                }
            }
            for (HyCaseMaterial caseMaterial : newCaseMaterials) {
                if (caseMaterial.getId() != null) {
                    caseMaterial.setUpdateBy(user);
                    caseMaterial.setUpdateDate(new Date());
                    caseMaterial.setDelFlag("0");
                    this.hyCaseMaterialDao.updateByPrimaryKey(caseMaterial);
                    if (caseMaterial.getCaseMaterialHeadId() != null && !caseMaterial.getCaseMaterialHeadId().trim().equals("")) {
                        headIds = new ArrayList();
                        headIds.add(caseMaterial.getCaseMaterialHeadId());
                        HyCaseMaterialCondition condition = new HyCaseMaterialCondition();
                        condition.setHeadIds(headIds);
                        List<HyCaseMaterial> list = this.hyCaseMaterialDao.selectByCondition(condition);
                        if (list == null || list.size() == 0) {
                            this.hyCaseMaterialHeadDao.deleteByPrimaryKey(caseMaterial.getCaseMaterialHeadId());
                        }
                    }
                    Iterator iterator = historyMap.keySet().iterator();
                    while (iterator.hasNext()) {
                        String key = (String)iterator.next();
                        if (!caseMaterial.getId().equals(key)) continue;
                        iterator.remove();
                        historyMap.remove(key);
                    }
                    continue;
                }
                caseMaterial.setId(IdGen.uuid());
                caseMaterial.setCreateBy(user);
                caseMaterial.setCreateDate(new Date());
                caseMaterial.setDelFlag("0");
                this.hyCaseMaterialDao.insert(caseMaterial);
            }
            for (Map.Entry entry : historyMap.entrySet()) {
                HyCaseMaterial caseMaterial = (HyCaseMaterial)entry.getValue();
                caseMaterial.setDelFlag("1");
                caseMaterial.setUpdateBy(user);
                caseMaterial.setUpdateDate(new Date());
                this.hyCaseMaterialDao.updateByPrimaryKeySelective(caseMaterial);
                if (caseMaterial.getCaseMaterialHeadId() == null || caseMaterial.getCaseMaterialHeadId().trim().equals("")) continue;
                headIds = new ArrayList();
                headIds.add(caseMaterial.getCaseMaterialHeadId());
                HyCaseMaterialCondition condition = new HyCaseMaterialCondition();
                condition.setHeadIds(headIds);
                List<HyCaseMaterial> list = this.hyCaseMaterialDao.selectByCondition(condition);
                if (list != null && list.size() != 0) continue;
                this.hyCaseMaterialHeadDao.deleteByPrimaryKey(caseMaterial.getCaseMaterialHeadId());
            }
        }
        return true;
    }

    public List<HyCaseMaterial> findCaseMaterials(String patientId) {
        ArrayList<HyCaseMaterial> result = new ArrayList<HyCaseMaterial>();
        if (patientId == null) {
            return result;
        }
        ArrayList<String> patientIds = new ArrayList<String>();
        patientIds.add(patientId);
        HyCaseMaterialCondition condition = new HyCaseMaterialCondition();
        condition.setPatientIdIn(patientIds);
        return this.hyCaseMaterialDao.selectByCondition(condition);
    }

    public CasePackageVo findHistoryWithoutCase(String patientId) {
        if (patientId == null) {
            return null;
        }
        CasePackageVo result = new CasePackageVo();
        result.setPatient(this.hyPatientService.findPatients(patientId));
        result.setGravidityHistory(this.hyGravidityHistoryService.findGravidities(patientId));
        result.setMedicalHistory(this.hyMedicalHistoryService.findMedicalHistory(patientId));
        return result;
    }

    public FamilyPatient<CasePackageVo> findFamilyCase(String maleId, String femaleId, String showAllCategory) {
        FamilyPatient<List<MaterialPackageVo>> familyMaterial;
        FamilyPatient familyMedicals;
        FamilyPatient familyGravidities;
        FamilyPatient result = new FamilyPatient();
        FamilyPatient familyPatients = this.hyPatientService.findFamilyPatients(maleId, femaleId);
        if (familyPatients == null || familyPatients.getMale() == null && familyPatients.getFemale() == null) {
            return result;
        }
        if (familyPatients.getMale() != null) {
            result.setMale((Object)new CasePackageVo());
            ((CasePackageVo)result.getMale()).setPatient((HyPatient)familyPatients.getMale());
        }
        if (familyPatients.getFemale() != null) {
            result.setFemale((Object)new CasePackageVo());
            ((CasePackageVo)result.getFemale()).setPatient((HyPatient)familyPatients.getFemale());
        }
        if ((familyGravidities = this.hyGravidityHistoryService.findFamilyGravidities(maleId, femaleId)) != null) {
            if (familyGravidities.getMale() != null) {
                ((CasePackageVo)result.getMale()).setGravidityHistory((HyGravidityHistory)familyGravidities.getMale());
            }
            if (familyGravidities.getFemale() != null) {
                ((CasePackageVo)result.getFemale()).setGravidityHistory((HyGravidityHistory)familyGravidities.getFemale());
            }
        }
        if ((familyMedicals = this.hyMedicalHistoryService.findFamilyMedicalHistory(maleId, femaleId)) != null) {
            if (familyMedicals.getMale() != null) {
                ((CasePackageVo)result.getMale()).setMedicalHistory((HyMedicalHistory)familyMedicals.getMale());
            }
            if (familyMedicals.getFemale() != null) {
                ((CasePackageVo)result.getFemale()).setMedicalHistory((HyMedicalHistory)familyMedicals.getFemale());
            }
        }
        if ((familyMaterial = this.findFamilyMaterial(maleId, femaleId, showAllCategory)) != null) {
            if (familyMaterial.getMale() != null && result.getMale() != null) {
                ((CasePackageVo)result.getMale()).setMaterials((List)familyMaterial.getMale());
            }
            if (familyMaterial.getFemale() != null && result.getFemale() != null) {
                ((CasePackageVo)result.getFemale()).setMaterials((List)familyMaterial.getFemale());
            }
        }
        return result;
    }

    public List<MaterialPackageVo> formatMaterialPackage(List<HyCaseMaterial> list) {
        ArrayList<MaterialPackageVo> result = new ArrayList<MaterialPackageVo>();
        if (list == null || list.size() == 0) {
            return result;
        }
        for (HyCaseMaterial hyCaseMaterial : list) {
            MaterialPackageVo voInResult = this.searchListByTopCategory(result, hyCaseMaterial.getCategory().getTopCategory().getId());
            if (voInResult == null) {
                voInResult = new MaterialPackageVo();
                result.add(voInResult);
                voInResult.setTopCategory(hyCaseMaterial.getCategory().getTopCategory());
                voInResult.setCaseMaterials(new ArrayList());
            }
            voInResult.getCaseMaterials().add(hyCaseMaterial);
        }
        return result;
    }

    public List<MaterialPackageVo> formatMaterialPackageWithAllCategory(List<HyCaseMaterial> list, HyCaseTopCategory condition) {
        List<HyCaseTopCategory> hyCaseTopCategories = this.hyCaseTopCategoryDao.selectListByCondition(condition);
        List<MaterialPackageVo> result = this.formatMaterialPackage(list);
        HashMap<String, HyCaseMaterial> caseMaterialMap = new HashMap<String, HyCaseMaterial>();
        if (list != null) {
            for (HyCaseMaterial caseMaterial : list) {
                caseMaterialMap.put(caseMaterial.getCategory().getTopCategory().getId(), caseMaterial);
            }
        }
        if (hyCaseTopCategories == null || hyCaseTopCategories.size() == 0) {
            return null;
        }
        for (HyCaseTopCategory hyCaseTopCategory : hyCaseTopCategories) {
            MaterialPackageVo voInResult = null;
            if (caseMaterialMap.containsKey(hyCaseTopCategory.getId())) continue;
            voInResult = new MaterialPackageVo();
            result.add(voInResult);
            voInResult.setTopCategory(hyCaseTopCategory);
            voInResult.setCaseMaterials(new ArrayList());
        }
        Collections.sort(result, new Comparator<MaterialPackageVo>(){

            @Override
            public int compare(MaterialPackageVo o1, MaterialPackageVo o2) {
                if (o1 == null && o2 == null) {
                    return 0;
                }
                if (o1.getTopCategory() == null || o1.getTopCategory().getOrderby() == null) {
                    return 1;
                }
                if (o2.getTopCategory() == null || o2.getTopCategory().getOrderby() == null) {
                    return -1;
                }
                return o1.getTopCategory().getOrderby().compareTo(o2.getTopCategory().getOrderby());
            }
        });
        return result;
    }

    public List<MaterialGroupVo> getMaterialsGroup(String patientId) {
        if (patientId == null) {
            return null;
        }
        HyCaseMaterialCondition condition = new HyCaseMaterialCondition();
        condition.setPatientIdIn(Arrays.asList(patientId));
        List<HyCaseMaterial> list = this.hyCaseMaterialDao.selectByCondition(condition);
        if (list == null || list.size() == 0) {
            return null;
        }
        ArrayList<MaterialGroupVo> result = new ArrayList<MaterialGroupVo>();
        for (HyCaseMaterial hyCaseMaterial : list) {
            MaterialGroupVo materialGroupVo = this.searchListByGroup(result, hyCaseMaterial);
            if (materialGroupVo == null) {
                materialGroupVo = new MaterialGroupVo();
                materialGroupVo.setSubCategory(hyCaseMaterial.getCategory());
                materialGroupVo.setDate(hyCaseMaterial.getAnalysisDate());
                materialGroupVo.setHospital(hyCaseMaterial.getAnalysisHospital());
                materialGroupVo.setCaseMaterials(new ArrayList());
                result.add(materialGroupVo);
            }
            materialGroupVo.getCaseMaterials().add(hyCaseMaterial);
        }
        return result;
    }

    public List<HyCaseMaterialHead> getCaseMaterialList(String patientId) {
        HyCaseMaterialCondition condition = new HyCaseMaterialCondition();
        condition.setPatientIdIn(Arrays.asList(patientId));
        List<HyCaseMaterialHead> headList = this.hyCaseMaterialHeadDao.selectByCondition(condition);
        ArrayList<String> headIds = new ArrayList<String>();
        for (HyCaseMaterialHead hyCaseMaterialHead : headList) {
            headIds.add(hyCaseMaterialHead.getId());
        }
        List<HyCaseMaterial> caseList = this.hyCaseMaterialDao.selectByCondition(condition);
        for (HyCaseMaterialHead hyCaseMaterialHead : headList) {
            for (HyCaseMaterial hyCaseMaterial : caseList) {
                if (hyCaseMaterial.getCaseMaterialHeadId() == null || !hyCaseMaterialHead.getId().equals(hyCaseMaterial.getCaseMaterialHeadId())) continue;
                if (hyCaseMaterialHead.getCaseMaterials() == null || hyCaseMaterialHead.getCaseMaterials().size() == 0) {
                    ArrayList<HyCaseMaterial> list = new ArrayList<HyCaseMaterial>();
                    list.add(hyCaseMaterial);
                    hyCaseMaterialHead.setCaseMaterials(list);
                    continue;
                }
                hyCaseMaterialHead.getCaseMaterials().add(hyCaseMaterial);
            }
        }
        ArrayList<HyCaseMaterial> arrayList = new ArrayList<HyCaseMaterial>();
        for (HyCaseMaterial hyCaseMaterial : caseList) {
            if (hyCaseMaterial.getCaseMaterialHeadId() != null && !hyCaseMaterial.getCaseMaterialHeadId().trim().equals("")) continue;
            arrayList.add(hyCaseMaterial);
        }
        ArrayList<MaterialGroupVo> arrayList2 = new ArrayList<MaterialGroupVo>();
        for (HyCaseMaterial hyCaseMaterial : arrayList) {
            MaterialGroupVo materialGroupVo = this.searchListByGroup(arrayList2, hyCaseMaterial);
            if (materialGroupVo == null) {
                materialGroupVo = new MaterialGroupVo();
                materialGroupVo.setSubCategory(hyCaseMaterial.getCategory());
                materialGroupVo.setDate(hyCaseMaterial.getAnalysisDate());
                materialGroupVo.setHospital(hyCaseMaterial.getAnalysisHospital());
                materialGroupVo.setCaseMaterials(new ArrayList());
                arrayList2.add(materialGroupVo);
            }
            materialGroupVo.getCaseMaterials().add(hyCaseMaterial);
        }
        Object var8_16 = null;
        for (MaterialGroupVo vo : arrayList2) {
            HyCaseMaterialHead hyCaseMaterialHead = new HyCaseMaterialHead();
            hyCaseMaterialHead.setCaseMaterials(vo.getCaseMaterials());
            hyCaseMaterialHead.setCategory(vo.getSubCategory());
            hyCaseMaterialHead.setAnalysisHospital(vo.getHospital());
            hyCaseMaterialHead.setAnalysisDate(vo.getDate());
            headList.add(hyCaseMaterialHead);
        }
        return headList;
    }

    /*
     * WARNING - void declaration
     */
    public void updateMaterialsByPatientId(List<HyCaseMaterialHead> headList, List<HyCaseMaterial> list, String patientId, String operatorId) {
        void var16_22;
        Date timeNow = new Date();
        HyCaseMaterialCondition condition = new HyCaseMaterialCondition();
        condition.setPatientIdIn(Arrays.asList(patientId));
        List<HyCaseMaterial> listInDb = this.hyCaseMaterialDao.selectByCondition(condition);
        ArrayList<HyCaseMaterial> willAdd = new ArrayList<HyCaseMaterial>();
        ArrayList<HyCaseMaterial> willDelete = new ArrayList<HyCaseMaterial>();
        ArrayList<HyCaseMaterial> willUpdate = new ArrayList<HyCaseMaterial>();
        List<HyCaseMaterialHead> headListInDb = this.hyCaseMaterialHeadDao.selectByCondition(condition);
        ArrayList<HyCaseMaterialHead> willHeadAdd = new ArrayList<HyCaseMaterialHead>();
        ArrayList<HyCaseMaterialHead> willHeadDelete = new ArrayList<HyCaseMaterialHead>();
        ArrayList<HyCaseMaterialHead> willHeadUpdate = new ArrayList<HyCaseMaterialHead>();
        for (HyCaseMaterialHead hyCaseMaterialHead : headList) {
            if (hyCaseMaterialHead.getId() == null) {
                willHeadAdd.add(hyCaseMaterialHead);
                continue;
            }
            if (this.findHeadInList(headListInDb, hyCaseMaterialHead.getId()) == null) {
                willHeadAdd.add(hyCaseMaterialHead);
                continue;
            }
            willHeadUpdate.add(hyCaseMaterialHead);
        }
        for (HyCaseMaterialHead hyCaseMaterialHead : headListInDb) {
            if (this.findHeadInList(headList, hyCaseMaterialHead.getId()) != null) continue;
            willHeadDelete.add(hyCaseMaterialHead);
        }
        ArrayList<Integer> eliminateAddHeadIds = new ArrayList<Integer>();
        for (HyCaseMaterial hyCaseMaterial : list) {
            if (hyCaseMaterial.getId() == null) {
                willAdd.add(hyCaseMaterial);
                continue;
            }
            if (this.findInList(listInDb, hyCaseMaterial.getId()) == null) {
                willAdd.add(hyCaseMaterial);
                continue;
            }
            if (hyCaseMaterial.getCaseMaterialHeadId() == null || hyCaseMaterial.getCaseMaterialHeadId().trim().equals("")) {
                eliminateAddHeadIds.add(hyCaseMaterial.getHeadAndCaseMaterNum());
            }
            willUpdate.add(hyCaseMaterial);
        }
        for (HyCaseMaterial hyCaseMaterial : listInDb) {
            if (this.findInList(list, hyCaseMaterial.getId()) != null) continue;
            willDelete.add(hyCaseMaterial);
        }
        boolean bl = false;
        while (var16_22 < willHeadAdd.size()) {
            for (Integer num : eliminateAddHeadIds) {
                if (!num.equals(((HyCaseMaterialHead)willHeadAdd.get((int)var16_22)).getHeadAndCaseMaterNum())) continue;
                willHeadAdd.remove((int)var16_22);
            }
            ++var16_22;
        }
        for (HyCaseMaterialHead hyCaseMaterialHead : willHeadAdd) {
            hyCaseMaterialHead.setId(IdGen.uuid());
            hyCaseMaterialHead.setCreateBy(new User(operatorId));
            hyCaseMaterialHead.setCreateDate(timeNow);
            this.hyCaseMaterialHeadDao.insert(hyCaseMaterialHead);
            for (HyCaseMaterial hyCaseMaterial : willAdd) {
                if (hyCaseMaterial.getHeadAndCaseMaterNum() != hyCaseMaterialHead.getHeadAndCaseMaterNum()) continue;
                hyCaseMaterial.setId(IdGen.uuid());
                hyCaseMaterial.setCreateBy(new User(operatorId));
                hyCaseMaterial.setCreateDate(timeNow);
                hyCaseMaterial.setCaseMaterialHeadId(hyCaseMaterialHead.getId());
                this.hyCaseMaterialDao.insert(hyCaseMaterial);
            }
        }
        if (willHeadAdd == null || willHeadAdd.size() == 0) {
            for (HyCaseMaterialHead hyCaseMaterialHead : headList) {
                for (HyCaseMaterial hyCaseMaterial : willAdd) {
                    if (hyCaseMaterial.getHeadAndCaseMaterNum() != hyCaseMaterialHead.getHeadAndCaseMaterNum()) continue;
                    hyCaseMaterial.setId(IdGen.uuid());
                    hyCaseMaterial.setCreateBy(new User(operatorId));
                    hyCaseMaterial.setCreateDate(timeNow);
                    hyCaseMaterial.setCaseMaterialHeadId(hyCaseMaterialHead.getId());
                    this.hyCaseMaterialDao.insert(hyCaseMaterial);
                }
            }
        }
        for (HyCaseMaterialHead hyCaseMaterialHead : willHeadDelete) {
            this.hyCaseMaterialHeadDao.deleteByPrimaryKey(hyCaseMaterialHead.getId());
        }
        for (HyCaseMaterialHead hyCaseMaterialHead : willHeadUpdate) {
            hyCaseMaterialHead.setUpdateDate(timeNow);
            hyCaseMaterialHead.setUpdateBy(new User(operatorId));
            this.hyCaseMaterialHeadDao.updateByPrimaryKeySelective(hyCaseMaterialHead);
        }
        for (HyCaseMaterial hyCaseMaterial : willDelete) {
            this.hyCaseMaterialDao.deleteByPrimaryKey(hyCaseMaterial.getId());
        }
        for (HyCaseMaterial hyCaseMaterial : willUpdate) {
            hyCaseMaterial.setUpdateDate(timeNow);
            hyCaseMaterial.setUpdateBy(new User(operatorId));
            this.hyCaseMaterialDao.updateByPrimaryKeySelective(hyCaseMaterial);
        }
    }

    public Page<HyCaseGroupByCreator> findWithCreateInfo(Page<HyCaseMaterial> page, HyCaseMaterialCondition condition) {
        if (condition == null || condition.getPatient() == null || condition.getPatient().getIdNo() == null) {
            return null;
        }
        Page<HyCaseMaterial> hyCaseMaterialPage = this.hyCaseMaterialDao.selectWithCreateInfo(page, condition);
        List<HyCaseGroupByCreator> hyCaseGroupByCreators = this.groupByCreator(hyCaseMaterialPage.getList());
        Page finalPage = new Page(hyCaseMaterialPage.getPageNo(), hyCaseMaterialPage.getPageSize(), hyCaseMaterialPage.getCount());
        finalPage.setList(hyCaseGroupByCreators);
        return finalPage;
    }

    public Page<HyCaseGroupByCreator> findCasesWithCreateInfo(Page<HyCaseMaterial> page, String idNo, Integer sex) {
        if (idNo == null || idNo.trim().equals("")) {
            return null;
        }
        HyCaseMaterialCondition condition = new HyCaseMaterialCondition();
        HyPatient p = new HyPatient();
        p.setIdNo(idNo);
        condition.setPatient(p);
        HyCaseSubCategory hyCaseSubCategory = new HyCaseSubCategory();
        HyCaseTopCategory hyCaseTopCategory = new HyCaseTopCategory();
        hyCaseTopCategory.setSex(sex);
        hyCaseSubCategory.setTopCategory(hyCaseTopCategory);
        condition.setCategory(hyCaseSubCategory);
        condition.setOrderIdAndHeadIdNotNull("1");
        Page<HyCaseMaterial> hyCaseMaterialPage = this.hyCaseMaterialDao.selectCaseWithCreateInfo(page, condition);
        List<HyCaseGroupByCreator> hyCaseGroupByCreators = this.groupByCasesCreator(hyCaseMaterialPage.getList());
        Page finalPage = new Page(hyCaseMaterialPage.getPageNo(), hyCaseMaterialPage.getPageSize(), hyCaseMaterialPage.getCount());
        finalPage.setList(hyCaseGroupByCreators);
        return finalPage;
    }

    private List<HyCaseGroupByCreator> groupByCreator(List<HyCaseMaterial> cases) {
        ArrayList<HyCaseGroupByCreator> result = new ArrayList<HyCaseGroupByCreator>();
        if (cases == null || cases.size() == 0) {
            return result;
        }
        for (HyCaseMaterial c : cases) {
            List casesGroupByAnalysisInfo;
            HyCaseGroupByAnalysisInfo groupByAnalysisInfo;
            HyCaseGroupByCreator groupbyCreator = HyCaseGroupByCreator.findByCaseInList(result, (Object)c);
            if (groupbyCreator == null) {
                groupbyCreator = new HyCaseGroupByCreator(c);
                result.add(groupbyCreator);
            }
            if ((groupByAnalysisInfo = HyCaseGroupByAnalysisInfo.findByCaseInList((List)(casesGroupByAnalysisInfo = groupbyCreator.getCasesGroupByAnalysisInfo()), (Object)c)) == null) {
                groupByAnalysisInfo = new HyCaseGroupByAnalysisInfo(c);
                casesGroupByAnalysisInfo.add(groupByAnalysisInfo);
            }
            groupByAnalysisInfo.getCases().add(c);
        }
        return result;
    }

    private List<HyCaseGroupByCreator> groupByCasesCreator(List<HyCaseMaterial> cases) {
        ArrayList<HyCaseGroupByCreator> result = new ArrayList<HyCaseGroupByCreator>();
        if (cases == null || cases.size() == 0) {
            return result;
        }
        for (HyCaseMaterial c : cases) {
            List casesGroupByAnalysisInfo;
            HyCaseGroupByAnalysisInfo groupByAnalysisInfo;
            HyCaseGroupByCreator groupbyCreator = HyCaseGroupByCreator.findByCaseInList2(result, (Object)c);
            if (groupbyCreator == null) {
                groupbyCreator = new HyCaseGroupByCreator(c);
                result.add(groupbyCreator);
            }
            if ((groupByAnalysisInfo = HyCaseGroupByAnalysisInfo.findByCaseInList2((List)(casesGroupByAnalysisInfo = groupbyCreator.getCasesGroupByAnalysisInfo()), (Object)c)) == null) {
                groupByAnalysisInfo = new HyCaseGroupByAnalysisInfo(c);
                casesGroupByAnalysisInfo.add(groupByAnalysisInfo);
            }
            groupByAnalysisInfo.getCases().add(c);
        }
        return result;
    }

    private HyCaseMaterial findInList(List<HyCaseMaterial> list, String id) {
        if (id == null) {
            return null;
        }
        if (list == null || list.size() == 0) {
            return null;
        }
        for (HyCaseMaterial hyCaseMaterial : list) {
            if (!id.equals(hyCaseMaterial.getId())) continue;
            return hyCaseMaterial;
        }
        return null;
    }

    private HyCaseMaterialHead findHeadInList(List<HyCaseMaterialHead> list, String id) {
        if (id == null) {
            return null;
        }
        if (list == null || list.size() == 0) {
            return null;
        }
        for (HyCaseMaterialHead hyCaseMaterialHead : list) {
            if (!id.equals(hyCaseMaterialHead.getId())) continue;
            return hyCaseMaterialHead;
        }
        return null;
    }

    private boolean equalsOrBothNull(Object t1, Object t2) {
        if (t1 == null && t2 == null) {
            return true;
        }
        if (t1 != null) {
            return t1.equals(t2);
        }
        return t2.equals(t1);
    }

    private MaterialGroupVo searchListByGroup(List<MaterialGroupVo> list, HyCaseMaterial hyCase) {
        if (list == null || hyCase == null) {
            return null;
        }
        for (MaterialGroupVo groupVo : list) {
            if (!this.equalsOrBothNull(groupVo.getSubCategory().getId(), hyCase.getCategory().getId()) || !this.equalsOrBothNull(groupVo.getDate(), hyCase.getAnalysisDate()) || !this.equalsOrBothNull(groupVo.getHospital(), hyCase.getAnalysisHospital())) continue;
            return groupVo;
        }
        return null;
    }

    private MaterialPackageVo searchListByTopCategory(List<MaterialPackageVo> list, String topCategoryId) {
        if (list == null || topCategoryId == null) {
            return null;
        }
        for (MaterialPackageVo materialPackageVo : list) {
            if (materialPackageVo.getTopCategory() == null || !topCategoryId.equals(materialPackageVo.getTopCategory().getId())) continue;
            return materialPackageVo;
        }
        return null;
    }
}

