/*
 * Decompiled with CFR 0.152.
 */
package com.cxqm.xiaoerke.modules.haoyun.service.impl;

import com.cxqm.xiaoerke.modules.haoyun.beans.HyCalendarDataByTelCommonSourceVo;
import com.cxqm.xiaoerke.modules.haoyun.beans.HyTelereferenceCommonSourceSectionCondition;
import com.cxqm.xiaoerke.modules.haoyun.dao.HyTelereferenceCommonSourceSectionDao;
import com.cxqm.xiaoerke.modules.haoyun.entity.HyTelereferenceCommonSourceSection;
import com.cxqm.xiaoerke.modules.haoyun.service.HyTelereferenceCommonSourceSectionService;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class HyTelereferenceCommonSourceSectionServiceImpl
implements HyTelereferenceCommonSourceSectionService {
    @Autowired
    private HyTelereferenceCommonSourceSectionDao hyTelereferenceCommonSourceSectionDao;

    public Map<String, List<HyCalendarDataByTelCommonSourceVo>> findSectionByCondition(HyTelereferenceCommonSourceSectionCondition commonSourceSectionCondition) {
        List<HyTelereferenceCommonSourceSection> sectionList = this.hyTelereferenceCommonSourceSectionDao.findSectionByCondition(commonSourceSectionCondition);
        HashMap<String, List<HyCalendarDataByTelCommonSourceVo>> sectionMap = new HashMap<String, List<HyCalendarDataByTelCommonSourceVo>>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        if (sectionList != null && sectionList.size() > 0) {
            for (HyTelereferenceCommonSourceSection section : sectionList) {
                HyCalendarDataByTelCommonSourceVo vo = new HyCalendarDataByTelCommonSourceVo();
                vo.setId(section.getId());
                vo.setTitle(section.getTitle());
                vo.setDate(section.getDate());
                vo.setStartTime(section.getStartTime());
                vo.setEndTime(section.getEndTime());
                vo.setSort(section.getSort());
                if (section.getCenterDoctorRelation() != null && section.getCenterDoctorRelation().getId() != null) {
                    vo.setCenterDoctorRelationId(section.getCenterDoctorRelation().getId());
                }
                if (section.getSubHospital() != null && section.getSubHospital().getId() != null) {
                    vo.setSubHospitalId(section.getSubHospital().getId());
                }
                vo.setPrice(section.getPrice());
                vo.setAllowance(section.getAllowance());
                long start = vo.getDate().getTime() + vo.getStartTime().getTime();
                long current = new Date().getTime() + (long)(new Date().getTimezoneOffset() * 60000);
                vo.setOverdue(Integer.valueOf(start > current ? 0 : 1));
                String key = sdf.format(section.getDate());
                ArrayList<HyCalendarDataByTelCommonSourceVo> list = (ArrayList<HyCalendarDataByTelCommonSourceVo>)sectionMap.get(key);
                if (list == null) {
                    list = new ArrayList<HyCalendarDataByTelCommonSourceVo>();
                    sectionMap.put(key, list);
                }
                list.add(vo);
            }
        }
        return sectionMap;
    }
}

