/*
 * Decompiled with CFR 0.152.
 */
package com.cxqm.xiaoerke.modules.haoyun.service.impl;

import com.cxqm.xiaoerke.common.bean.BusinessException;
import com.cxqm.xiaoerke.common.bean.IErrorInfo;
import com.cxqm.xiaoerke.common.utils.MD5Util;
import com.cxqm.xiaoerke.modules.haoyun.beans.HaoyunErrors;
import com.cxqm.xiaoerke.modules.haoyun.service.HyUserService;
import com.cxqm.xiaoerke.modules.sys.dao.UserDao;
import com.cxqm.xiaoerke.modules.sys.entity.User;
import com.cxqm.xiaoerke.modules.sys.service.SystemService;
import com.cxqm.xiaoerke.modules.verifycode.beans.VerifyCodeSType;
import com.cxqm.xiaoerke.modules.verifycode.service.VerifycodeService;
import com.zthzinfo.sdks.netease.im.bean.NetEaseEntity;
import com.zthzinfo.sdks.netease.im.service.NEIMUserService;
import com.zthzinfo.sdks.netease.im.vo.NEIMUser;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class HyUserServiceImpl
implements HyUserService {
    @Autowired
    private UserDao userDao;
    @Autowired
    private SystemService systemService;
    @Autowired
    private NEIMUserService neimUserService;
    @Autowired
    VerifycodeService verifycodeService;

    public static boolean containtUserTypes(String[] userTypes, String userType) {
        if (userTypes == null || userTypes.length == 0 || userType == null || userType.trim().length() == 0) {
            return false;
        }
        for (String item : userTypes) {
            if (!userType.equals(item)) continue;
            return true;
        }
        return false;
    }

    public NetEaseEntity<User> validateLoginByPassword(String loginName, String password, String[] userTypes) {
        NEIMUser neUser;
        User condition = new User();
        condition.setLoginName(loginName);
        User user = this.userDao.getUserEntityByLoginName(condition);
        if (user == null || user.getUserType() == null) {
            throw new BusinessException((IErrorInfo)HaoyunErrors.PWD_ERROR);
        }
        if (!SystemService.validatePassword((String)password, (String)user.getPassword())) {
            throw new BusinessException((IErrorInfo)HaoyunErrors.PWD_ERROR);
        }
        if (userTypes != null && !HyUserServiceImpl.containtUserTypes(userTypes, user.getUserType())) {
            throw new BusinessException((IErrorInfo)HaoyunErrors.DOCTOR_NOT_EXISTS);
        }
        NEIMUser userInfo = this.neimUserService.getUserInfo(user.getLoginName());
        String originStr4NEToken = user.getLoginName() + "8^l}{M?l.";
        String neToken = MD5Util.MD5Encode((String)originStr4NEToken, (String)"utf-8");
        if (userInfo == null && (neUser = this.neimUserService.createUser(user.getLoginName(), neToken, user.getName(), null, null)) == null) {
            throw new BusinessException((IErrorInfo)HaoyunErrors.FAILED_REGISTER_NEUSER);
        }
        return new NetEaseEntity((Object)user, neToken);
    }

    public NetEaseEntity<User> validateLoginByVerificationCode(String loginName, String verificationCode, String[] userTypes) {
        NEIMUser neUser;
        User condition = new User();
        condition.setLoginName(loginName);
        User user = this.userDao.getUserEntityByLoginName(condition);
        if (user == null || user.getUserType() == null) {
            throw new BusinessException((IErrorInfo)HaoyunErrors.MOBILE_OR_VERIFYCODE_ERROR);
        }
        boolean verify = this.verifycodeService.validateCode(VerifyCodeSType.HYZS_DORCTORAPP_LOGIN, loginName, verificationCode);
        if (!verify) {
            throw new BusinessException((IErrorInfo)HaoyunErrors.MOBILE_OR_VERIFYCODE_ERROR);
        }
        if (userTypes != null && !HyUserServiceImpl.containtUserTypes(userTypes, user.getUserType())) {
            throw new BusinessException((IErrorInfo)HaoyunErrors.DOCTOR_NOT_EXISTS);
        }
        NEIMUser userInfo = this.neimUserService.getUserInfo(user.getLoginName());
        String originStr4NEToken = user.getLoginName() + "8^l}{M?l.";
        String neToken = MD5Util.MD5Encode((String)originStr4NEToken, (String)"utf-8");
        if (userInfo == null && (neUser = this.neimUserService.createUser(user.getLoginName(), neToken, user.getName(), null, null)) == null) {
            throw new BusinessException((IErrorInfo)HaoyunErrors.FAILED_REGISTER_NEUSER);
        }
        return new NetEaseEntity((Object)user, neToken);
    }

    public User get(String id) {
        User condition = new User();
        condition.setId(id);
        return this.userDao.getUserEntityById(condition);
    }

    public String resetPwd(User condition, String oldPassword, String newPassword) {
        User user = this.userDao.getUserEntityByLoginName(condition);
        if (!SystemService.validatePassword((String)oldPassword, (String)user.getPassword())) {
            throw new BusinessException((IErrorInfo)HaoyunErrors.PWD_ERROR);
        }
        String pwd = SystemService.entryptPassword((String)newPassword);
        user.setPassword(pwd);
        int i = this.userDao.updatePasswordById(user);
        String result = i > 0 ? "\u4fee\u6539\u6210\u529f" : "\u4fee\u6539\u5931\u8d25";
        return result;
    }

    public String resetPwdByVerifyCode(String loginName, String verifyCode, String newPassword) {
        User condition = new User();
        condition.setLoginName(loginName);
        User user = this.userDao.getUserEntityByLoginName(condition);
        if (user == null || user.getUserType() == null) {
            throw new BusinessException((IErrorInfo)HaoyunErrors.MOBILE_OR_VERIFYCODE_ERROR);
        }
        boolean verify = this.verifycodeService.validateCode(VerifyCodeSType.HYZS_DORCTORAPP_RESETPWD, user.getLoginName(), verifyCode);
        if (!verify) {
            throw new BusinessException((IErrorInfo)HaoyunErrors.MOBILE_OR_VERIFYCODE_ERROR);
        }
        String pwd = SystemService.entryptPassword((String)newPassword);
        user.setPassword(pwd);
        int i = this.userDao.updatePasswordById(user);
        String result = i > 0 ? "\u4fee\u6539\u6210\u529f" : "\u4fee\u6539\u5931\u8d25";
        return result;
    }
}

