/*
 * Decompiled with CFR 0.152.
 */
package com.cxqm.xiaoerke.modules.haoyun.service.impl;

import com.cxqm.xiaoerke.common.config.Global;
import com.cxqm.xiaoerke.modules.haoyun.service.HyWechatPushService;
import com.cxqm.xiaoerke.modules.haoyun.util.PushWechatMsgUtils;
import com.cxqm.xiaoerke.modules.sys.beans.PushWechatMsg;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class HyWechatPushServiceImpl
implements HyWechatPushService {
    @Autowired
    private RedisTemplate redisTemplate;
    private static final String reKey = "chat.user.";

    public void savePushRedisFiveMinutWithin(String userId) {
        String key = reKey + userId;
        this.redisTemplate.opsForValue().set((Object)key, (Object)userId);
        this.redisTemplate.expire((Object)key, 300L, TimeUnit.SECONDS);
    }

    public boolean isFiveMinutBack(String userId) {
        if (userId == null || userId.trim().equals("")) {
            return false;
        }
        String key = reKey + userId;
        if (this.redisTemplate.opsForValue().get((Object)key) == null) {
            System.out.println(key + " \u5df2\u6e05\u9664");
            return true;
        }
        System.out.println(key + " \u8fd8\u672a\u6e05\u9664");
        return false;
    }

    public void pushWechat(String userId, String fromName, String msgTime, String message, String url) {
        if (userId != null && this.isFiveMinutBack(userId)) {
            PushWechatMsg pushWechatMsg = new PushWechatMsg();
            pushWechatMsg.setUserId(userId);
            pushWechatMsg.setFromName(fromName + " \u533b\u751f");
            pushWechatMsg.setMessage(message);
            pushWechatMsg.setMsgTime(msgTime);
            pushWechatMsg.setUrl(url);
            pushWechatMsg.setModelId(Global.getConfig((String)"public_wechat_template_id"));
            PushWechatMsgUtils.pushWechatMsgRedisQueue(pushWechatMsg);
        }
    }
}

