/*
 * Decompiled with CFR 0.152.
 */
package com.cxqm.xiaoerke.modules.haoyun.event.listener;

import com.cxqm.xiaoerke.common.config.Global;
import com.cxqm.xiaoerke.modules.consult.entity.Message;
import com.cxqm.xiaoerke.modules.consult.event.UnReadEvent;
import com.cxqm.xiaoerke.modules.haoyun.service.HyWechatPushService;
import com.cxqm.xiaoerke.modules.push.service.PushNetService;
import com.cxqm.xiaoerke.modules.sys.utils.TokenKeyUtil;
import com.cxqm.xiaoerke.modules.wechat.push.AngelWechatPushService;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.stereotype.Component;

@Component
@EnableAsync
public class UnReadEventMessageListener
implements ApplicationListener<UnReadEvent> {
    @Autowired
    PushNetService pushNetService;
    @Autowired
    HyWechatPushService hyWechatPushService;
    @Autowired
    AngelWechatPushService angelWechatPushService;
    SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    @Async
    public void onApplicationEvent(UnReadEvent unReadEvent) {
        Message msg = (Message)unReadEvent.getSource();
        if ("user".equals(msg.getSendusertype())) {
            this.pushUserToDocter(msg);
        } else if ("doctor".equals(msg.getSendusertype())) {
            this.pushDocterToUser(msg);
        }
    }

    private void pushUserToDocter(Message msg) {
        try {
            HashMap<String, String> dictionary = new HashMap<String, String>();
            dictionary.put("openurl", msg.getOpenurl());
            this.pushNetService.push(msg.getUserId(), "ios", null, null, null, dictionary, msg.getPushcount(), "graphicconsult", msg.getSendname() + "\uff1a" + msg.getEscapeMsgImg());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String templateId = Global.getConfig((String)"doctor_wechat_template_id");
        this.angelWechatPushService.pushByUserId(msg.getUserId(), templateId, msg.getOpenurl(), "\u7b2c\u4e00\u4e2a\u5b57\u7b26\u4e32", msg.getSendname(), this.formatter.format(new Date()), msg.getEscapeMsgImg(), "\u5907\u6ce8", TokenKeyUtil.doctor_key);
    }

    private void pushDocterToUser(Message msg) {
        this.hyWechatPushService.pushWechat(msg.getUserId(), msg.getSendname(), this.formatter.format(new Date()), msg.getEscapeMsgImg(), msg.getOpenurl());
    }
}

