/*
 * Decompiled with CFR 0.152.
 */
package com.cxqm.xiaoerke.modules.haoyun.service.impl;

import com.cxqm.xiaoerke.common.bean.BusinessException;
import com.cxqm.xiaoerke.common.bean.IErrorInfo;
import com.cxqm.xiaoerke.common.persistence.Page;
import com.cxqm.xiaoerke.common.utils.IdGen;
import com.cxqm.xiaoerke.modules.haoyun.beans.HaoyunErrors;
import com.cxqm.xiaoerke.modules.haoyun.dao.DoctorZHYDao;
import com.cxqm.xiaoerke.modules.haoyun.entity.DoctorInfoCookie;
import com.cxqm.xiaoerke.modules.haoyun.entity.DoctorZHY;
import com.cxqm.xiaoerke.modules.haoyun.example.DoctorZHYExample;
import com.cxqm.xiaoerke.modules.haoyun.service.DoctorZHYService;
import com.cxqm.xiaoerke.modules.sys.dao.UserDao;
import com.cxqm.xiaoerke.modules.sys.entity.User;
import com.cxqm.xiaoerke.modules.sys.entity.WechatUserInfo;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DoctorZHYServiceImpl
implements DoctorZHYService {
    @Autowired
    DoctorZHYDao doctorZHYDao;
    @Autowired
    UserDao userDao;

    public User packageUser(User user, DoctorZHY doctorZHY) {
        if (user == null) {
            throw new BusinessException((IErrorInfo)HaoyunErrors.USER_NOT_EXISTS);
        }
        if (doctorZHY == null) {
            throw new BusinessException((IErrorInfo)HaoyunErrors.DOCTOR_NOT_EXISTS);
        }
        user.setDoctorOpenid(doctorZHY.getOpenid());
        user.setPassword(doctorZHY.getPassword());
        user.setUserType("doctor");
        user.setName(doctorZHY.getName());
        return user;
    }

    public DoctorZHY getDoctorByDoctorOpenidAndNotId(String id, String openid) {
        DoctorZHYExample doctorZHYExample = new DoctorZHYExample();
        doctorZHYExample.createCriteria().andIdNotEqualTo(id).andOpenidEqualTo(openid);
        List<DoctorZHY> list = this.queryDoctorZHY(doctorZHYExample);
        if (list == null || list.size() == 0) {
            return null;
        }
        return list.get(0);
    }

    public DoctorInfoCookie packageDoctorInfoCookie(User user) {
        DoctorInfoCookie doctor = new DoctorInfoCookie();
        doctor.setLoginName(user.getLoginName() == null ? null : user.getLoginName());
        doctor.setName(user.getName() == null ? null : user.getName());
        doctor.setUserType("doctor");
        doctor.setPassword(user.getPassword() == null ? null : user.getPassword());
        doctor.setUnionId(user.getUnionId() == null ? null : user.getUnionId());
        doctor.setOpenid(user.getOpenid() == null ? null : user.getOpenid());
        doctor.setId(user.getId());
        return doctor;
    }

    public DoctorInfoCookie packageDoctorInfoCookie(DoctorZHY doctorZHY) {
        DoctorInfoCookie doctor = new DoctorInfoCookie();
        doctor.setLoginName(doctorZHY.getLoginName() == null ? null : doctorZHY.getLoginName());
        doctor.setName(doctorZHY.getName() == null ? null : doctorZHY.getName());
        doctor.setUserType("doctor");
        doctor.setPassword(doctorZHY.getPassword() == null ? null : doctorZHY.getPassword());
        doctor.setUnionId(doctorZHY.getUnionid() == null ? null : doctorZHY.getUnionid());
        doctor.setOpenid(doctorZHY.getOpenid() == null ? null : doctorZHY.getOpenid());
        doctor.setZhyDoctorId(doctorZHY.getId());
        return doctor;
    }

    public User saveUserInfo(DoctorZHY doctorZHY) {
        User user = this.mergeDoctorZhy(doctorZHY);
        this.userDao.insert((Object)user);
        user.setDoctorOpenid(doctorZHY.getOpenid());
        this.userDao.updateDoctorOpenidById(user);
        return user;
    }

    private User mergeDoctorZhy(DoctorZHY doctorZHY) {
        User user = new User();
        user.setId(IdGen.vestaId());
        user.setLoginName(doctorZHY.getLoginName() == null ? null : doctorZHY.getLoginName());
        user.setName(doctorZHY.getName() == null ? null : doctorZHY.getName());
        user.setUserType("doctor");
        user.setPassword(doctorZHY.getPassword() == null ? null : doctorZHY.getPassword());
        user.setUnionId(doctorZHY.getUnionid() == null ? null : doctorZHY.getUnionid());
        return user;
    }

    public Page<DoctorZHY> findPage(Page<DoctorZHY> page, String sysUserId) {
        DoctorZHY doctorZHY = new DoctorZHY();
        doctorZHY.setInviterSysUserId(sysUserId);
        return this.doctorZHYDao.selectPage(page, doctorZHY);
    }

    public void rejectDoctorZhy(String id) {
        DoctorZHY doctorZHY = new DoctorZHY();
        doctorZHY.setId(id);
        doctorZHY.setAuthenStatus(DoctorZHY.AUTHEN_FAILD_STAUTS);
        this.doctorZHYDao.updateByPrimaryKeySelective(doctorZHY);
    }

    public void adoptDoctorZhy(String id) {
        DoctorZHY doctorZHY = new DoctorZHY();
        doctorZHY.setId(id);
        doctorZHY.setAuthenStatus(DoctorZHY.AUTHEN_SUCCESS_STAUTS);
        this.doctorZHYDao.updateByPrimaryKeySelective(doctorZHY);
    }

    public DoctorZHY getDetailById(String id) {
        DoctorZHYExample doctorZHYExample = new DoctorZHYExample();
        doctorZHYExample.createCriteria().andIdEqualTo(id);
        List<DoctorZHY> list = this.queryDoctorZHY(doctorZHYExample);
        if (list == null || list.size() == 0) {
            return null;
        }
        return list.get(0);
    }

    public void update(DoctorZHY doctorZHY) {
        this.doctorZHYDao.updateByPrimaryKeySelective(doctorZHY);
    }

    public DoctorZHY saveOrUpdate(String name, String login_name, String password, String hospital_id, String department, String sys_user_id, WechatUserInfo wechatUserInfo) {
        DoctorZHY currentDoctor = this.getDoctorZHYByLoginName(login_name);
        if (currentDoctor == null) {
            currentDoctor = new DoctorZHY();
        }
        currentDoctor.setName(name);
        currentDoctor.setLoginName(login_name);
        currentDoctor.setPassword(password);
        currentDoctor.setHospitalId(hospital_id);
        currentDoctor.setDepartment(department);
        currentDoctor.setInviterSysUserId(sys_user_id);
        currentDoctor.setAuthenStatus(DoctorZHY.AUTHEN_WAIT_STAUTS);
        if (wechatUserInfo != null) {
            currentDoctor.setUnionid(wechatUserInfo.getUnionid());
            currentDoctor.setOpenid(wechatUserInfo.getOpenid());
        }
        if (currentDoctor.getId() == null || currentDoctor.getId().trim().equals("")) {
            this.insert(currentDoctor);
        } else {
            currentDoctor.setUpdateDate(new Date());
            this.doctorZHYDao.updateByPrimaryKeySelective(currentDoctor);
        }
        return currentDoctor;
    }

    public void insert(DoctorZHY doctorZHY) {
        doctorZHY.setId(IdGen.vestaId());
        doctorZHY.setCreateDate(new Date());
        this.doctorZHYDao.insertSelective(doctorZHY);
    }

    public DoctorZHY getDoctorZHYByLoginName(String loginName) {
        DoctorZHYExample doctorZHYExample = new DoctorZHYExample();
        doctorZHYExample.createCriteria().andLoginNameEqualTo(loginName);
        List<DoctorZHY> list = this.queryDoctorZHY(doctorZHYExample);
        if (list == null || list.size() == 0) {
            return null;
        }
        return list.get(0);
    }

    private List<DoctorZHY> queryDoctorZHY(DoctorZHYExample doctorZHYExample) {
        return this.doctorZHYDao.selectByExample(doctorZHYExample);
    }
}

