/*
 * Decompiled with CFR 0.152.
 */
package com.cxqm.xiaoerke.modules.haoyun.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.cxqm.xiaoerke.common.bean.BusinessException;
import com.cxqm.xiaoerke.common.bean.IErrorInfo;
import com.cxqm.xiaoerke.common.filter.MUserInfo;
import com.cxqm.xiaoerke.common.persistence.Page;
import com.cxqm.xiaoerke.common.queue.RedisDelayQueue;
import com.cxqm.xiaoerke.common.queue.RedisDelayQueueTiming;
import com.cxqm.xiaoerke.common.utils.IdGen;
import com.cxqm.xiaoerke.common.utils.OSSObjectTool;
import com.cxqm.xiaoerke.common.utils.SpringContextHolder;
import com.cxqm.xiaoerke.modules.consult.entity.ConsultRecordMongoVo;
import com.cxqm.xiaoerke.modules.consult.entity.Message;
import com.cxqm.xiaoerke.modules.consult.enums.MessageStatus;
import com.cxqm.xiaoerke.modules.consult.event.UnReadEvent;
import com.cxqm.xiaoerke.modules.consult.service.impl.ConsultRecordMongoDBServiceImpl;
import com.cxqm.xiaoerke.modules.consult.service.impl.GraphicChatServiceImpl;
import com.cxqm.xiaoerke.modules.haoyun.beans.HaoyunErrors;
import com.cxqm.xiaoerke.modules.haoyun.beans.HyGraphicOrderCondition;
import com.cxqm.xiaoerke.modules.haoyun.beans.HyGraphicOrderVo;
import com.cxqm.xiaoerke.modules.haoyun.dao.HyGraphicOrderDao;
import com.cxqm.xiaoerke.modules.haoyun.entity.HyGraphicOrder;
import com.cxqm.xiaoerke.modules.haoyun.enums.GraphicOrderInputStepEnum;
import com.cxqm.xiaoerke.modules.haoyun.enums.GraphicOrderStatusEnum;
import com.cxqm.xiaoerke.modules.haoyun.queue.GraphicStopOrderDelayQueueEntity;
import com.cxqm.xiaoerke.modules.haoyun.service.HyGraphicOrderService;
import com.cxqm.xiaoerke.modules.sys.entity.DoctorVo;
import com.cxqm.xiaoerke.modules.sys.entity.User;
import com.cxqm.xiaoerke.modules.sys.service.DoctorInfoService;
import com.cxqm.xiaoerke.modules.sys.service.UserInfoService;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.stereotype.Service;

@Service
public class HyGraphicOrderServiceImpl
implements HyGraphicOrderService {
    @Autowired
    private HyGraphicOrderDao hyGraphicOrderDao;
    @Autowired
    RedisDelayQueue delayQueue;
    @Autowired
    private DoctorInfoService doctorInfoService;
    @Autowired
    private ConsultRecordMongoDBServiceImpl consultRecordMongoDBService;
    @Autowired
    private GraphicChatServiceImpl graphicChatServiceImpl;
    @Autowired
    UserInfoService userInfoServiceImpl;

    public float findIncome(String doctorId) {
        HyGraphicOrder query = new HyGraphicOrder();
        query.setOrderStatus(GraphicOrderStatusEnum.END.getValue());
        DoctorVo vo = new DoctorVo();
        vo.setId(doctorId);
        query.setDoctor(vo);
        Float income = this.hyGraphicOrderDao.findIncome(query);
        if (income == null) {
            income = Float.valueOf(0.0f);
        }
        return income.floatValue();
    }

    public HyGraphicOrder saveOrUpdate(HyGraphicOrder record, User user) {
        if (record == null) {
            return null;
        }
        if (record.getId() != null) {
            if (record.getCreateBy() == null && user != null) {
                record.setUpdateBy(user);
            }
            if (record.getUpdateDate() == null) {
                record.setUpdateDate(new Date());
            }
            this.hyGraphicOrderDao.updateByPrimaryKeySelective(record);
        } else {
            record.setId(IdGen.vestaId());
            record.setDelFlag("0");
            if (user != null) {
                record.setCreateBy(user);
            }
            record.setIsConfirm(GraphicOrderStatusEnum.UNCONFIRMTMP.getValue());
            record.setCreateDate(new Date());
            record.setOrderNo(IdGen.orderNo());
            record.setOrderStatus(GraphicOrderStatusEnum.WAIT_PAY.getValue());
            this.hyGraphicOrderDao.insert(record);
        }
        return this.hyGraphicOrderDao.findByPrimaryKey(record.getId());
    }

    public List<HyGraphicOrder> findListByCondtion(HyGraphicOrderCondition condition) {
        return this.hyGraphicOrderDao.findListByCondition(condition);
    }

    public List<HyGraphicOrder> findListUserinfoByCondition(HyGraphicOrderCondition condition) {
        return this.hyGraphicOrderDao.findListUserinfoByCondition(condition);
    }

    public List<HyGraphicOrder> findListByStatusCondition(HyGraphicOrderCondition condition) {
        return this.hyGraphicOrderDao.findListByStatusCondition(condition);
    }

    public Page<HyGraphicOrder> findPageByCondtion(Page<HyGraphicOrder> page, HyGraphicOrderCondition condition) {
        return this.hyGraphicOrderDao.findPageByCondtion(page, condition);
    }

    public int delete(String id) {
        return this.hyGraphicOrderDao.deleteByPrimaryKey(id);
    }

    public HyGraphicOrder findByPrimaryKey(String id) {
        return this.hyGraphicOrderDao.findByPrimaryKey(id);
    }

    public String getCaseImgJsonurls(HyGraphicOrder hyGraphicOrder) {
        String[] filenames;
        String jsonurl = "";
        if (hyGraphicOrder != null && hyGraphicOrder.getCaseInfo() != null && hyGraphicOrder.getCaseInfo().length() > 0 && (filenames = hyGraphicOrder.getCaseInfo().split(";")) != null && filenames.length > 0) {
            JSONArray jsonArray = new JSONArray();
            for (int i = 0; i < filenames.length; ++i) {
                jsonArray.add((Object)OSSObjectTool.getUrl((String)filenames[i], (String)OSSObjectTool.BUCKET_CASE_PIC));
            }
            jsonurl = jsonArray.toString();
        }
        return jsonurl;
    }

    public void payedOrder(String id) {
    }

    public void stopOrder(String orderId, User user) {
        if (orderId == null || orderId.equals("")) {
            throw new BusinessException((IErrorInfo)HaoyunErrors.ORDER_ROOM_ERROR);
        }
        HyGraphicOrder hyGraphicOrder = this.findByPrimaryKey(orderId);
        hyGraphicOrder.setOrderStatus(GraphicOrderStatusEnum.END.getValue());
        hyGraphicOrder.setInputStep(GraphicOrderInputStepEnum.EVALUATE.getValue());
        this.saveOrUpdate(hyGraphicOrder, user);
        this.delayQueue.cancel((RedisDelayQueueTiming)new GraphicStopOrderDelayQueueEntity(orderId));
    }

    public Page<HyGraphicOrderVo> findCurrentUserorder(int pageNo, int pageSize, int orderstatus, User user) {
        HyGraphicOrderCondition graphicOrderCondition = new HyGraphicOrderCondition();
        if ("user".equals(user.getUserType())) {
            graphicOrderCondition.setUser(user);
        } else if ("doctor".equals(user.getUserType())) {
            DoctorVo doctorCondtion = new DoctorVo();
            doctorCondtion.setSysUserId(user.getId());
            graphicOrderCondition.setDoctor(doctorCondtion);
        }
        if (orderstatus != 0) {
            graphicOrderCondition.setOrderStatus(Integer.valueOf(orderstatus));
        }
        graphicOrderCondition.setOrder(Integer.valueOf(1));
        Page pageCondition = new Page(pageNo, pageSize);
        Page<HyGraphicOrder> page = this.hyGraphicOrderDao.findPageByCondtion((Page<HyGraphicOrder>)pageCondition, graphicOrderCondition);
        ArrayList<HyGraphicOrderVo> hyGraphicOrderVos = new ArrayList<HyGraphicOrderVo>();
        if (page != null && page.getList() != null && page.getList().size() > 0) {
            for (HyGraphicOrder order : page.getList()) {
                HyGraphicOrderVo vo = new HyGraphicOrderVo(order);
                hyGraphicOrderVos.add(vo);
            }
        }
        Page pagevo = new Page(page.getPageNo(), page.getPageSize(), page.getCount(), hyGraphicOrderVos);
        return pagevo;
    }

    public void confirmTmp(String orderId) {
        HyGraphicOrder hyGraphicOrder = this.hyGraphicOrderDao.findByPrimaryKey(orderId);
        if (hyGraphicOrder.getIsConfirm() == GraphicOrderStatusEnum.UNCONFIRMTMP.getValue()) {
            hyGraphicOrder.setIsConfirm(GraphicOrderStatusEnum.CONFIRMTMP.getValue());
            this.saveOrUpdate(hyGraphicOrder, MUserInfo.getUserInfoValue());
            ConsultRecordMongoVo consultRecordMongoVo = new ConsultRecordMongoVo();
            consultRecordMongoVo.setIsRead(MessageStatus.UNREAD.getValue());
            consultRecordMongoVo.setAcceptId(hyGraphicOrder.getDoctor().getSysUserId());
            consultRecordMongoVo.setSenderId(hyGraphicOrder.getUser().getId());
            consultRecordMongoVo.setMessage("");
            consultRecordMongoVo.setOrderno(hyGraphicOrder.getId());
            consultRecordMongoVo.setTimestamp(hyGraphicOrder.getCreateDate().getTime());
            this.consultRecordMongoDBService.insert(consultRecordMongoVo);
        }
        User user_allinfo = this.userInfoServiceImpl.getUserById(hyGraphicOrder.getUser().getId());
        Message message = new Message();
        message.setSendname(user_allinfo.getName());
        message.setBinglxq();
        message.setUserId(hyGraphicOrder.getDoctor().getSysUserId());
        message.setFromAccount(hyGraphicOrder.getUser().getId());
        message.setUserHeard(user_allinfo.getFullPhoto());
        message.setOpenurl(orderId);
        message.setOrderid(orderId);
        message.setSendusertype(user_allinfo.getUserType());
        int feednum = this.graphicChatServiceImpl.queryCount(orderId, hyGraphicOrder.getDoctor().getSysUserId());
        int pushnum = this.graphicChatServiceImpl.queryCount(null, hyGraphicOrder.getDoctor().getSysUserId());
        message.setFeedcount(String.valueOf(feednum + 1));
        message.setPushcount(String.valueOf(pushnum + 1));
        try {
            SpringContextHolder.getApplicationContext().publishEvent((ApplicationEvent)new UnReadEvent(message));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

