/*
 * Decompiled with CFR 0.152.
 */
package com.cxqm.xiaoerke.modules.haoyun.service.impl;

import com.cxqm.xiaoerke.common.persistence.Page;
import com.cxqm.xiaoerke.common.utils.IdGen;
import com.cxqm.xiaoerke.modules.haoyun.beans.FamilyPatient;
import com.cxqm.xiaoerke.modules.haoyun.beans.HyPatientCondition;
import com.cxqm.xiaoerke.modules.haoyun.dao.HyPatientDao;
import com.cxqm.xiaoerke.modules.haoyun.entity.HyGravidityHistory;
import com.cxqm.xiaoerke.modules.haoyun.entity.HyMedicalHistory;
import com.cxqm.xiaoerke.modules.haoyun.entity.HyPatient;
import com.cxqm.xiaoerke.modules.haoyun.service.HyGravidityHistoryService;
import com.cxqm.xiaoerke.modules.haoyun.service.HyMedicalHistoryService;
import com.cxqm.xiaoerke.modules.haoyun.service.HyPatientService;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class HyPatientServiceImpl
implements HyPatientService {
    @Autowired
    private HyPatientDao hyPatientDao;
    @Autowired
    private HyMedicalHistoryService hyMedicalHistoryService;
    @Autowired
    private HyGravidityHistoryService hyGravidityHistoryService;

    public FamilyPatient<HyPatient> findFamilyPatients(String maleId, String femaleId) {
        if (maleId == null && femaleId == null) {
            return null;
        }
        ArrayList<String> idIn = new ArrayList<String>();
        if (maleId != null) {
            idIn.add(maleId);
        }
        if (femaleId != null) {
            idIn.add(femaleId);
        }
        HyPatientCondition condition = new HyPatientCondition();
        condition.setIdIn(idIn);
        List<HyPatient> list = this.hyPatientDao.findListByCondition(condition);
        if (list == null || list.size() == 0) {
            return null;
        }
        FamilyPatient result = new FamilyPatient();
        for (HyPatient hyPatient : list) {
            if (maleId != null && maleId.equals(hyPatient.getId())) {
                result.setMale((Object)hyPatient);
            }
            if (femaleId == null || !femaleId.equals(hyPatient.getId())) continue;
            result.setFemale((Object)hyPatient);
        }
        return result;
    }

    public HyPatient findPatients(String patientId) {
        if (patientId == null) {
            return null;
        }
        HyPatientCondition condition = new HyPatientCondition();
        condition.setId(patientId);
        List<HyPatient> list = this.hyPatientDao.findListByCondition(condition);
        if (list == null || list.size() == 0) {
            return null;
        }
        return list.get(0);
    }

    public HyPatient selectByPrimaryKey(String id) {
        return this.hyPatientDao.selectByPrimaryKey(id);
    }

    public void insert(HyPatient hyPatient) {
        this.hyPatientDao.insert(hyPatient);
    }

    public void update(HyPatient hyPatient) {
        this.hyPatientDao.updateByPrimaryKey(hyPatient);
    }

    public HyPatient savePatientInfo(HyPatient hp) {
        HyPatient patient = null;
        if (hp.getId() == null || hp.getId().equals("")) {
            hp.setId(IdGen.uuid());
            hp.setCreateDate(new Date());
            this.insert(hp);
            patient = hp;
        } else {
            patient = this.findPatients(hp.getId());
            if (hp.getName() != null) {
                patient.setName(hp.getName());
            }
            if (hp.getIdNo() != null) {
                patient.setIdNo(hp.getIdNo());
            }
            if (hp.getHeight() != null) {
                patient.setHeight(hp.getHeight());
            }
            if (hp.getWeight() != null) {
                patient.setWeight(hp.getWeight());
            }
            if (hp.getPeriodDays() != null) {
                patient.setPeriodDays(hp.getPeriodDays());
            }
            if (hp.getPeriodInterval() != null) {
                patient.setPeriodInterval(hp.getPeriodInterval());
            }
            if (hp.getPeriodAmount() != null) {
                patient.setPeriodAmount(hp.getPeriodAmount());
            }
            if (hp.getPeriodIsPain() != null) {
                patient.setPeriodIsPain(hp.getPeriodIsPain());
            }
            if (hp.getPeriodFirstAge() != null) {
                patient.setPeriodFirstAge(hp.getPeriodFirstAge());
            }
            patient.setUpdateDate(new Date());
            this.update(patient);
        }
        return patient;
    }

    public void saveSickHistoryInfo(HyMedicalHistory hyMedicalHistory) {
        if (hyMedicalHistory.getId() != null && hyMedicalHistory.getId().trim().length() > 0) {
            HyMedicalHistory temp = this.hyMedicalHistoryService.findMedicalHistoryById(hyMedicalHistory.getId());
            temp.setUpdateDate(new Date());
            temp.setMedicalHistory(hyMedicalHistory.getMedicalHistory().replaceAll("&nbsp;", ""));
            temp.setSmokeNumber(hyMedicalHistory.getSmokeNumber());
            temp.setDrinkFrequency(hyMedicalHistory.getDrinkFrequency());
            temp.setIndustry(hyMedicalHistory.getIndustry());
            temp.setOperatedHistory(hyMedicalHistory.getOperatedHistory());
            temp.setAllergyHistory(hyMedicalHistory.getAllergyHistory());
            temp.setAllergyHistoryDescribe(hyMedicalHistory.getAllergyHistoryDescribe());
            temp.setHasIvf(hyMedicalHistory.getHasIvf());
            temp.setHasAi(hyMedicalHistory.getHasAi());
            temp.setHasCnDoctor(hyMedicalHistory.getHasCnDoctor());
            temp.setHasOtherTreat(hyMedicalHistory.getHasOtherTreat());
            temp.setFamilyHeredityStd(hyMedicalHistory.getFamilyHeredityStd());
            temp.setFamilyTherioma(hyMedicalHistory.getFamilyTherioma());
            temp.setFamilyOtherIll(hyMedicalHistory.getFamilyOtherIll());
            this.hyMedicalHistoryService.update(temp);
        } else {
            hyMedicalHistory.setId(IdGen.uuid());
            hyMedicalHistory.setCreateDate(new Date());
            hyMedicalHistory.setMedicalHistory(hyMedicalHistory.getMedicalHistory().replaceAll("&nbsp;", ""));
            this.hyMedicalHistoryService.insert(hyMedicalHistory);
        }
    }

    public void savePregnantHistory(HyGravidityHistory hyGravidityHistory) {
        if (hyGravidityHistory.getId() == null || hyGravidityHistory.getId().equals("")) {
            hyGravidityHistory.setId(IdGen.uuid());
            hyGravidityHistory.setCreateDate(new Date());
            this.hyGravidityHistoryService.insert(hyGravidityHistory);
        } else {
            hyGravidityHistory.setUpdateDate(new Date());
            this.hyGravidityHistoryService.update(hyGravidityHistory);
        }
    }

    public Page<HyPatient> findPageByCondition(Page<HyPatient> page, HyPatientCondition condition) {
        return this.hyPatientDao.findPageByCondition(page, condition);
    }

    public List<HyPatient> findValidListByCondition(HyPatientCondition condition) {
        return this.hyPatientDao.findValidListByCondition(condition);
    }
}

