/*
 * Decompiled with CFR 0.152.
 */
package com.cxqm.xiaoerke.modules.haoyun.service.impl;

import com.cxqm.xiaoerke.common.bean.BusinessException;
import com.cxqm.xiaoerke.common.bean.IErrorInfo;
import com.cxqm.xiaoerke.common.bean.ParamNotNullError;
import com.cxqm.xiaoerke.common.junit.AssertEx;
import com.cxqm.xiaoerke.common.utils.IdGen;
import com.cxqm.xiaoerke.modules.haoyun.beans.HaoyunErrors;
import com.cxqm.xiaoerke.modules.haoyun.dao.SysUserCollectDao;
import com.cxqm.xiaoerke.modules.haoyun.entity.SysUserCollect;
import com.cxqm.xiaoerke.modules.haoyun.example.SysUserCollectExample;
import com.cxqm.xiaoerke.modules.haoyun.service.SysUserCollectService;
import com.cxqm.xiaoerke.modules.sys.entity.User;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SysUserCollectServiceImpl
implements SysUserCollectService {
    @Autowired
    private SysUserCollectDao sysUserCollectDao;

    public Map findIsCollect(String collectUserId, String collectArticleId, String currentUserId, boolean isQueryCollect) {
        this.validateSysUserCollect(collectUserId, collectArticleId, currentUserId);
        return this.findOrDeleteCollectByIsQueryCollect(collectUserId, collectArticleId, currentUserId, isQueryCollect);
    }

    private Map findOrDeleteCollectByIsQueryCollect(String collectUserId, String collectArticleId, String currentUserId, boolean isQueryFollow) {
        this.validateSysUserCollect(collectUserId, collectArticleId, currentUserId);
        HashMap<String, Object> map = new HashMap<String, Object>();
        SysUserCollect sysUserCollect = this.findSysUserCollect(collectUserId, collectArticleId, currentUserId);
        if (isQueryFollow) {
            int articleCount = this.countSysUserCollectByUserCollectIdAndArticleId(collectUserId, collectArticleId);
            if (sysUserCollect == null) {
                map.put("displayMsg", "\u6536\u85cf");
                map.put("showCollect", true);
                map.put("collectCount", articleCount);
                return map;
            }
            map.put("displayMsg", "\u53d6\u6d88\u6536\u85cf");
            map.put("showCollect", false);
            map.put("collectCount", articleCount);
            return map;
        }
        if (sysUserCollect == null) {
            if (this.saveSysUserCollect(collectUserId, collectArticleId, currentUserId) == 1) {
                int articleCount = this.countSysUserCollectByUserCollectIdAndArticleId(collectUserId, collectArticleId);
                map.put("promptMsg", "\u6536\u85cf\u6210\u529f!");
                map.put("displayMsg", "\u53d6\u6d88\u6536\u85cf");
                map.put("showCollect", false);
                map.put("collectCount", articleCount);
                return map;
            }
            throw new BusinessException((IErrorInfo)HaoyunErrors.COllECT_FAILED);
        }
        if (this.deleteSysUserCollect(sysUserCollect) == 1) {
            int articleCount = this.countSysUserCollectByUserCollectIdAndArticleId(collectUserId, collectArticleId);
            map.put("promptMsg", "\u53d6\u6d88\u6536\u85cf\u6210\u529f!");
            map.put("displayMsg", "\u6536\u85cf");
            map.put("showCollect", true);
            map.put("collectCount", articleCount);
            return map;
        }
        throw new BusinessException((IErrorInfo)HaoyunErrors.CANCEL_COllECT_FAILED);
    }

    private int saveSysUserCollect(String collectUserId, String collectArticleId, String currentUserId) {
        this.validateSysUserCollect(collectUserId, collectArticleId, currentUserId);
        SysUserCollect sysUserCollect = new SysUserCollect();
        sysUserCollect.setId(IdGen.vestaId());
        sysUserCollect.setOfArticleId(collectArticleId);
        sysUserCollect.setOfSysUser(new User(collectUserId));
        sysUserCollect.setSysUser(new User(currentUserId));
        sysUserCollect.setCreateBy(new User(currentUserId));
        return this.sysUserCollectDao.insertSelective(sysUserCollect);
    }

    private int countSysUserCollectByUserCollectIdAndArticleId(String collectUserId, String collectArticleId) {
        SysUserCollectExample sysUserCollectExample = new SysUserCollectExample();
        sysUserCollectExample.createCriteria().andOfSysUserEqualTo(new User(collectUserId)).andOfArticleIdEqualTo(collectArticleId);
        return this.sysUserCollectDao.countByExample(sysUserCollectExample);
    }

    private int deleteSysUserCollect(SysUserCollect sysUserCollect) {
        if (sysUserCollect == null) {
            return 0;
        }
        return this.sysUserCollectDao.deleteByPrimaryKey(sysUserCollect.getId());
    }

    private int deleteSysUserCollect(String collectUserId, String collectArticleId, String currentUserId) {
        this.validateSysUserCollect(collectUserId, collectArticleId, currentUserId);
        SysUserCollectExample sysUserCollectExample = new SysUserCollectExample();
        sysUserCollectExample.createCriteria().andSysUserEqualTo(new User(currentUserId)).andOfSysUserEqualTo(new User(collectUserId)).andOfArticleIdEqualTo(collectArticleId);
        return this.sysUserCollectDao.deleteByExample(sysUserCollectExample);
    }

    private SysUserCollect findSysUserCollect(String collectUserId, String collectArticleId, String currentUserId) {
        this.validateSysUserCollect(collectUserId, collectArticleId, currentUserId);
        SysUserCollectExample sysUserCollectExample = new SysUserCollectExample();
        sysUserCollectExample.createCriteria().andSysUserEqualTo(new User(currentUserId)).andOfSysUserEqualTo(new User(collectUserId)).andOfArticleIdEqualTo(collectArticleId);
        List<SysUserCollect> list = this.sysUserCollectDao.selectByExample(sysUserCollectExample);
        if (list == null || list.size() == 0) {
            return null;
        }
        return list.get(0);
    }

    private void validateSysUserCollect(String collectUserId, String collectArticleId, String currentUserId) {
        AssertEx.assertNotNullByError((IErrorInfo)new ParamNotNullError("collectUserId"), (Object)collectUserId);
        AssertEx.assertNotNullByError((IErrorInfo)new ParamNotNullError("collectArticleId"), (Object)collectArticleId);
        AssertEx.assertNotNullByError((IErrorInfo)new ParamNotNullError("currentUserId"), (Object)currentUserId);
    }
}

