/*
 * Decompiled with CFR 0.152.
 */
package com.robert.vesta.service.factory;

import com.mchange.v2.c3p0.ComboPooledDataSource;
import com.robert.vesta.service.impl.IdServiceImpl;
import com.robert.vesta.service.impl.provider.DbMachineIdProvider;
import com.robert.vesta.service.impl.provider.IpConfigurableMachineIdProvider;
import com.robert.vesta.service.impl.provider.PropertyMachineIdProvider;
import com.robert.vesta.service.intf.IdService;
import java.beans.PropertyVetoException;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.jdbc.core.JdbcTemplate;

public class IdServiceFactoryBean
implements FactoryBean<IdService> {
    protected final Logger log = LoggerFactory.getLogger(IdServiceFactoryBean.class);
    private Type providerType;
    private long machineId;
    private String ips;
    private String dbUrl;
    private String dbName;
    private String dbUser;
    private String dbPassword;
    private long genMethod = -1L;
    private long type = -1L;
    private long version = -1L;
    private IdService idService;

    public void init() {
        if (this.providerType == null) {
            this.log.error("The type of Id service is mandatory.");
            throw new IllegalArgumentException("The type of Id service is mandatory.");
        }
        switch (this.providerType) {
            case PROPERTY: {
                this.idService = this.constructPropertyIdService(this.machineId);
                break;
            }
            case IP_CONFIGURABLE: {
                this.idService = this.constructIpConfigurableIdService(this.ips);
                break;
            }
            case DB: {
                this.idService = this.constructDbIdService(this.dbUrl, this.dbName, this.dbUser, this.dbPassword);
            }
        }
    }

    public IdService getObject() throws Exception {
        return this.idService;
    }

    private IdService constructPropertyIdService(long machineId) {
        this.log.info("Construct Property IdService machineId {}", (Object)machineId);
        PropertyMachineIdProvider propertyMachineIdProvider = new PropertyMachineIdProvider();
        propertyMachineIdProvider.setMachineId(machineId);
        IdServiceImpl idServiceImpl = new IdServiceImpl();
        idServiceImpl.setMachineIdProvider(propertyMachineIdProvider);
        if (this.genMethod != -1L) {
            idServiceImpl.setGenMethod(this.genMethod);
        }
        if (this.type != -1L) {
            idServiceImpl.setType(this.type);
        }
        if (this.version != -1L) {
            idServiceImpl.setVersion(this.version);
        }
        idServiceImpl.init();
        return idServiceImpl;
    }

    private IdService constructIpConfigurableIdService(String ips) {
        this.log.info("Construct Ip Configurable IdService ips {}", (Object)ips);
        IpConfigurableMachineIdProvider ipConfigurableMachineIdProvider = new IpConfigurableMachineIdProvider(ips);
        IdServiceImpl idServiceImpl = new IdServiceImpl();
        idServiceImpl.setMachineIdProvider(ipConfigurableMachineIdProvider);
        if (this.genMethod != -1L) {
            idServiceImpl.setGenMethod(this.genMethod);
        }
        if (this.type != -1L) {
            idServiceImpl.setType(this.type);
        }
        if (this.version != -1L) {
            idServiceImpl.setVersion(this.version);
        }
        idServiceImpl.init();
        return idServiceImpl;
    }

    private IdService constructDbIdService(String dbUrl, String dbName, String dbUser, String dbPassword) {
        this.log.info("Construct Db IdService dbUrl {} dbName {} dbUser {} dbPassword {}", new Object[]{dbUrl, dbName, dbUser, dbPassword});
        ComboPooledDataSource comboPooledDataSource = new ComboPooledDataSource();
        String jdbcDriver = "com.mysql.jdbc.Driver";
        try {
            comboPooledDataSource.setDriverClass(jdbcDriver);
        }
        catch (PropertyVetoException e) {
            this.log.error("Wrong JDBC driver {}", (Object)jdbcDriver);
            this.log.error("Wrong JDBC driver error: ", (Throwable)e);
            throw new IllegalStateException("Wrong JDBC driver ", e);
        }
        comboPooledDataSource.setMinPoolSize(5);
        comboPooledDataSource.setMaxPoolSize(30);
        comboPooledDataSource.setIdleConnectionTestPeriod(20);
        comboPooledDataSource.setMaxIdleTime(25);
        comboPooledDataSource.setBreakAfterAcquireFailure(false);
        comboPooledDataSource.setCheckoutTimeout(3000);
        comboPooledDataSource.setAcquireRetryAttempts(50);
        comboPooledDataSource.setAcquireRetryDelay(1000);
        String url = String.format("jdbc:mysql://%s/%s?useUnicode=true&amp;characterEncoding=UTF-8&amp;autoReconnect=true", dbUrl, dbName);
        comboPooledDataSource.setJdbcUrl(url);
        comboPooledDataSource.setUser(dbUser);
        comboPooledDataSource.setPassword(dbPassword);
        JdbcTemplate jdbcTemplate = new JdbcTemplate();
        jdbcTemplate.setLazyInit(false);
        jdbcTemplate.setDataSource((DataSource)comboPooledDataSource);
        DbMachineIdProvider dbMachineIdProvider = new DbMachineIdProvider();
        dbMachineIdProvider.setJdbcTemplate(jdbcTemplate);
        dbMachineIdProvider.init();
        IdServiceImpl idServiceImpl = new IdServiceImpl();
        idServiceImpl.setMachineIdProvider(dbMachineIdProvider);
        if (this.genMethod != -1L) {
            idServiceImpl.setGenMethod(this.genMethod);
        }
        if (this.type != -1L) {
            idServiceImpl.setType(this.type);
        }
        if (this.version != -1L) {
            idServiceImpl.setVersion(this.version);
        }
        idServiceImpl.init();
        return idServiceImpl;
    }

    public Class<?> getObjectType() {
        return IdService.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public Type getProviderType() {
        return this.providerType;
    }

    public void setProviderType(Type providerType) {
        this.providerType = providerType;
    }

    public long getMachineId() {
        return this.machineId;
    }

    public void setMachineId(long machineId) {
        this.machineId = machineId;
    }

    public String getIps() {
        return this.ips;
    }

    public void setIps(String ips) {
        this.ips = ips;
    }

    public String getDbUrl() {
        return this.dbUrl;
    }

    public void setDbUrl(String dbUrl) {
        this.dbUrl = dbUrl;
    }

    public String getDbName() {
        return this.dbName;
    }

    public void setDbName(String dbName) {
        this.dbName = dbName;
    }

    public String getDbUser() {
        return this.dbUser;
    }

    public void setDbUser(String dbUser) {
        this.dbUser = dbUser;
    }

    public String getDbPassword() {
        return this.dbPassword;
    }

    public void setDbPassword(String dbPassword) {
        this.dbPassword = dbPassword;
    }

    public long getGenMethod() {
        return this.genMethod;
    }

    public void setGenMethod(long genMethod) {
        this.genMethod = genMethod;
    }

    public long getType() {
        return this.type;
    }

    public void setType(long type) {
        this.type = type;
    }

    public long getVersion() {
        return this.version;
    }

    public void setVersion(long version) {
        this.version = version;
    }

    public static enum Type {
        PROPERTY,
        IP_CONFIGURABLE,
        DB;

    }
}

