/*
 * Decompiled with CFR 0.152.
 */
package com.robert.vesta.service.impl;

import com.robert.vesta.service.bean.Id;
import com.robert.vesta.service.impl.bean.IdMeta;
import com.robert.vesta.service.impl.bean.IdMetaFactory;
import com.robert.vesta.service.impl.bean.IdType;
import com.robert.vesta.service.impl.converter.IdConverter;
import com.robert.vesta.service.impl.converter.IdConverterImpl;
import com.robert.vesta.service.impl.provider.MachineIdProvider;
import com.robert.vesta.service.intf.IdService;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractIdServiceImpl
implements IdService {
    public static final long EPOCH = 1420041600000L;
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected long machineId = -1L;
    protected long genMethod = 0L;
    protected long type = 0L;
    protected long version = 0L;
    protected IdType idType;
    protected IdMeta idMeta;
    protected IdConverter idConverter;
    protected MachineIdProvider machineIdProvider;

    public AbstractIdServiceImpl() {
        this.idType = IdType.MAX_PEAK;
    }

    public AbstractIdServiceImpl(String type) {
        this.idType = IdType.parse(type);
    }

    public AbstractIdServiceImpl(IdType type) {
        this.idType = type;
    }

    public void init() {
        this.machineId = this.machineIdProvider.getMachineId();
        if (this.machineId < 0L) {
            this.log.error("The machine ID is not configured properly so that Vesta Service refuses to start.");
            throw new IllegalStateException("The machine ID is not configured properly so that Vesta Service refuses to start.");
        }
        this.setIdMeta(IdMetaFactory.getIdMeta(this.idType));
        this.setType(this.idType.value());
        this.setIdConverter(new IdConverterImpl(this.idType));
    }

    public long genId() {
        Id id = new Id();
        this.populateId(id);
        id.setMachine(this.machineId);
        id.setGenMethod(this.genMethod);
        id.setType(this.type);
        id.setVersion(this.version);
        long ret = this.idConverter.convert(id);
        if (this.log.isTraceEnabled()) {
            this.log.trace(String.format("Id: %s => %d", id, ret));
        }
        return ret;
    }

    protected abstract void populateId(Id var1);

    protected long genTime() {
        if (this.idType == IdType.MAX_PEAK) {
            return (System.currentTimeMillis() - 1420041600000L) / 1000L;
        }
        if (this.idType == IdType.MIN_GRANULARITY) {
            return System.currentTimeMillis() - 1420041600000L;
        }
        return (System.currentTimeMillis() - 1420041600000L) / 1000L;
    }

    public Id expId(long id) {
        return this.idConverter.convert(id);
    }

    public long makeId(long time, long seq) {
        return this.makeId(time, seq, this.machineId);
    }

    public long makeId(long time, long seq, long machine) {
        return this.makeId(this.genMethod, time, seq, machine);
    }

    public long makeId(long genMethod, long time, long seq, long machine) {
        return this.makeId(this.type, genMethod, time, seq, machine);
    }

    public long makeId(long type, long genMethod, long time, long seq, long machine) {
        return this.makeId(this.version, type, genMethod, time, seq, machine);
    }

    public long makeId(long version, long type, long genMethod, long time, long seq, long machine) {
        IdType idType = IdType.parse(type);
        Id id = new Id(machine, seq, time, genMethod, type, version);
        IdConverterImpl idConverter = new IdConverterImpl(idType);
        return idConverter.convert(id);
    }

    public Date transTime(long time) {
        if (this.idType == IdType.MAX_PEAK) {
            return new Date(time * 1000L + 1420041600000L);
        }
        if (this.idType == IdType.MIN_GRANULARITY) {
            return new Date(time + 1420041600000L);
        }
        return null;
    }

    public void setMachineId(long machineId) {
        this.machineId = machineId;
    }

    public void setGenMethod(long genMethod) {
        this.genMethod = genMethod;
    }

    public void setType(long type) {
        this.type = type;
    }

    public void setVersion(long version) {
        this.version = version;
    }

    public void setIdConverter(IdConverter idConverter) {
        this.idConverter = idConverter;
    }

    public void setIdMeta(IdMeta idMeta) {
        this.idMeta = idMeta;
    }

    public void setMachineIdProvider(MachineIdProvider machineIdProvider) {
        this.machineIdProvider = machineIdProvider;
    }
}

