/*
 * Decompiled with CFR 0.152.
 */
package com.robert.vesta.service.impl;

import com.robert.vesta.service.bean.Id;
import com.robert.vesta.service.impl.AbstractIdServiceImpl;
import com.robert.vesta.service.impl.bean.IdType;
import com.robert.vesta.service.intf.IdService;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class IdServiceImpl
extends AbstractIdServiceImpl
implements IdService {
    private long sequence = 0L;
    private long lastTimestamp = -1L;
    private Lock lock = new ReentrantLock();

    public IdServiceImpl() {
    }

    public IdServiceImpl(String type) {
        super(type);
    }

    public IdServiceImpl(IdType type) {
        super(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void populateId(Id id) {
        this.lock.lock();
        try {
            long timestamp = this.genTime();
            this.validateTimestamp(this.lastTimestamp, timestamp);
            if (timestamp == this.lastTimestamp) {
                ++this.sequence;
                this.sequence &= this.idMeta.getSeqBitsMask();
                if (this.sequence == 0L) {
                    timestamp = this.tillNextTimeUnit(this.lastTimestamp);
                }
            } else {
                this.lastTimestamp = timestamp;
                this.sequence = 0L;
            }
            id.setSeq(this.sequence);
            id.setTime(timestamp);
        }
        finally {
            this.lock.unlock();
        }
    }

    private void validateTimestamp(long lastTimestamp, long timestamp) {
        if (timestamp < lastTimestamp) {
            if (this.log.isErrorEnabled()) {
                this.log.error(String.format("Clock moved backwards.  Refusing to generate id for %d %s.", lastTimestamp - timestamp, this.idType == IdType.MAX_PEAK ? "second" : "milisecond"));
            }
            throw new IllegalStateException(String.format("Clock moved backwards.  Refusing to generate id for %d %s.", lastTimestamp - timestamp, this.idType == IdType.MAX_PEAK ? "second" : "milisecond"));
        }
    }

    protected long tillNextTimeUnit(long lastTimestamp) {
        if (this.log.isInfoEnabled()) {
            this.log.info(String.format("Ids are used out during %d in machine %d. Waiting till next %s.", lastTimestamp, this.machineId, this.idType == IdType.MAX_PEAK ? "second" : "milisecond"));
        }
        long timestamp = this.genTime();
        while (timestamp <= lastTimestamp) {
            timestamp = this.genTime();
        }
        if (this.log.isInfoEnabled()) {
            this.log.info(String.format("Next %s %d is up.", this.idType == IdType.MAX_PEAK ? "second" : "milisecond", timestamp));
        }
        return timestamp;
    }
}

