/*
 * Decompiled with CFR 0.152.
 */
package com.robert.vesta.service.impl.converter;

import com.robert.vesta.service.bean.Id;
import com.robert.vesta.service.impl.bean.IdMeta;
import com.robert.vesta.service.impl.bean.IdMetaFactory;
import com.robert.vesta.service.impl.bean.IdType;
import com.robert.vesta.service.impl.converter.IdConverter;

public class IdConverterImpl
implements IdConverter {
    private IdType idType;

    public IdConverterImpl() {
    }

    public IdConverterImpl(IdType idType) {
        this.idType = idType;
    }

    @Override
    public long convert(Id id) {
        return this.doConvert(id, IdMetaFactory.getIdMeta(this.idType));
    }

    protected long doConvert(Id id, IdMeta idMeta) {
        long ret = 0L;
        ret |= id.getMachine();
        ret |= id.getSeq() << (int)idMeta.getSeqBitsStartPos();
        ret |= id.getTime() << (int)idMeta.getTimeBitsStartPos();
        ret |= id.getGenMethod() << (int)idMeta.getGenMethodBitsStartPos();
        ret |= id.getType() << (int)idMeta.getTypeBitsStartPos();
        return ret |= id.getVersion() << (int)idMeta.getVersionBitsStartPos();
    }

    @Override
    public Id convert(long id) {
        return this.doConvert(id, IdMetaFactory.getIdMeta(this.idType));
    }

    protected Id doConvert(long id, IdMeta idMeta) {
        Id ret = new Id();
        ret.setMachine(id & idMeta.getMachineBitsMask());
        ret.setSeq(id >>> (int)idMeta.getSeqBitsStartPos() & idMeta.getSeqBitsMask());
        ret.setTime(id >>> (int)idMeta.getTimeBitsStartPos() & idMeta.getTimeBitsMask());
        ret.setGenMethod(id >>> (int)idMeta.getGenMethodBitsStartPos() & idMeta.getGenMethodBitsMask());
        ret.setType(id >>> (int)idMeta.getTypeBitsStartPos() & idMeta.getTypeBitsMask());
        ret.setVersion(id >>> (int)idMeta.getVersionBitsStartPos() & idMeta.getVersionBitsMask());
        return ret;
    }

    public IdType getIdType() {
        return this.idType;
    }

    public void setIdType(IdType idType) {
        this.idType = idType;
    }
}

