/*
 * Decompiled with CFR 0.152.
 */
package com.robert.vesta.service.impl.provider;

import com.robert.vesta.service.impl.provider.MachineIdProvider;
import com.robert.vesta.util.IpUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.util.StringUtils;

public class DbMachineIdProvider
implements MachineIdProvider {
    private static final Logger log = LoggerFactory.getLogger(DbMachineIdProvider.class);
    private long machineId;
    private JdbcTemplate jdbcTemplate;

    public DbMachineIdProvider() {
        log.debug("IpConfigurableMachineIdProvider constructed.");
    }

    public void init() {
        String ip = IpUtils.getHostIp();
        if (StringUtils.isEmpty((Object)ip)) {
            String msg = "Fail to get host IP address. Stop to initialize the DbMachineIdProvider provider.";
            log.error(msg);
            throw new IllegalStateException(msg);
        }
        Long id = null;
        try {
            id = (Long)this.jdbcTemplate.queryForObject("select ID from DB_MACHINE_ID_PROVIDER where IP = ?", new Object[]{ip}, Long.class);
        }
        catch (EmptyResultDataAccessException e) {
            log.error("No allocation before for ip {}.", (Object)ip);
        }
        if (id != null) {
            this.machineId = id;
            return;
        }
        log.info("Fail to get ID from DB for host IP address {}. Next step try to allocate one.", (Object)ip);
        int count = this.jdbcTemplate.update("update DB_MACHINE_ID_PROVIDER set IP = ? where IP is null limit 1", new Object[]{ip});
        if (count <= 0 || count > 1) {
            String msg = String.format("Fail to allocte ID for host IP address {}. The {} records are updated. Stop to initialize the DbMachineIdProvider provider.", ip, count);
            log.error(msg);
            throw new IllegalStateException(msg);
        }
        try {
            id = (Long)this.jdbcTemplate.queryForObject("select ID from DB_MACHINE_ID_PROVIDER where IP = ?", new Object[]{ip}, Long.class);
        }
        catch (EmptyResultDataAccessException e) {
            log.error("Fail to do allocation for ip {}.", (Object)ip);
        }
        if (id == null) {
            String msg = String.format("Fail to get ID from DB for host IP address {} after allocation. Stop to initialize the DbMachineIdProvider provider.", ip);
            log.error(msg);
            throw new IllegalStateException(msg);
        }
        this.machineId = id;
    }

    @Override
    public long getMachineId() {
        return this.machineId;
    }

    public void setMachineId(long machineId) {
        this.machineId = machineId;
    }

    public JdbcTemplate getJdbcTemplate() {
        return this.jdbcTemplate;
    }

    public void setJdbcTemplate(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }
}

