/*
 * Decompiled with CFR 0.152.
 */
package com.robert.vesta.util;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IpUtils {
    private static final Logger log = LoggerFactory.getLogger(IpUtils.class);

    public static String getHostIp() {
        String ip = null;
        try {
            Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
            while (en.hasMoreElements()) {
                NetworkInterface intf = en.nextElement();
                Enumeration<InetAddress> enumIpAddr = intf.getInetAddresses();
                while (enumIpAddr.hasMoreElements()) {
                    InetAddress inetAddress = enumIpAddr.nextElement();
                    if (inetAddress.isLoopbackAddress() || inetAddress.isLinkLocalAddress() || !inetAddress.isSiteLocalAddress()) continue;
                    ip = inetAddress.getHostAddress();
                }
            }
        }
        catch (SocketException e) {
            log.error("Fail to get IP address.", (Throwable)e);
        }
        return ip;
    }

    public static String getHostName() {
        String hostName = null;
        try {
            Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
            while (en.hasMoreElements()) {
                NetworkInterface intf = en.nextElement();
                Enumeration<InetAddress> enumIpAddr = intf.getInetAddresses();
                while (enumIpAddr.hasMoreElements()) {
                    InetAddress inetAddress = enumIpAddr.nextElement();
                    if (inetAddress.isLoopbackAddress() || inetAddress.isLinkLocalAddress() || !inetAddress.isSiteLocalAddress()) continue;
                    hostName = inetAddress.getHostName();
                }
            }
        }
        catch (SocketException e) {
            log.error("Fail to get host name.", (Throwable)e);
        }
        return hostName;
    }
}

