package com.zthz.wxapi.util;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;

public class ObjectUtils {

	private static Logger logger = LoggerFactory.getLogger(ObjectUtils.class);

	/**
	 ** 获取利用反射获取类里面的值和名称
	 **
	 ** @param obj
	 ** @return
	 ** @throws IllegalAccessException
	 */
	public static Map<String, Object> objectToMap(Object obj){
		Map<String, Object> map = new HashMap<>();
		Class<?> clazz = obj.getClass();

		for (Field field : clazz.getDeclaredFields()) {
			field.setAccessible(true);
			String fieldName = field.getName();
			String value = null;
			try {
				Object v = field.get(obj);
				if(v!=null){
					value = String.valueOf(v);
				}
			}catch (Exception e){
				logger.error("取出"+fieldName+"的值时发生异常！");
				continue;
			}

			if(value==null||value.length()<=0){
				continue;
			}
			map.put(fieldName, value);
		}
		return map;
	}

}
