package com.zthzinfo.common;


import java.util.HashMap;
import java.util.Map;

public class ResponseMapBuilder {

	public static final String KEY_RESULTCODE = "resultCode";
	public static final String KEY_RESULTMSG = "resultMsg";


	public static ResponseMapBuilder emptyBuilder() {
		ResponseMapBuilder builder = new ResponseMapBuilder();
		return builder;
	}

	public static ResponseMapBuilder newBuilder() {
		ResponseMapBuilder builder = new ResponseMapBuilder();
		builder.result = new HashMap<String, Object>();
		return builder;
	}

	public static ResponseMapBuilder newBuilder(Map<String, Object> result) {
		ResponseMapBuilder builder = new ResponseMapBuilder();
		builder.result = result;
		return builder;
	}

	private ResponseMapBuilder() {
	}

	private Map<String, Object> result;

	public Map<String, Object> getResult() {
		return result;
	}

	public void setResult(Map<String, Object> result) {
		this.result = result;
	}

	public ResponseMapBuilder putSuccess() {
		if (result == null) {
			return this;
		}

		put(KEY_RESULTCODE, "0");
		put(KEY_RESULTMSG, "");
		return this;
	}
	public ResponseMapBuilder putBusinessException(BusinessException e) {
		if (e == null) {
			return this;
		}
		put(KEY_RESULTCODE, e.getError().getCode());
		put(KEY_RESULTMSG, e.getError().getDesc());
		return this;
	}

	public ResponseMapBuilder put(String property, Object value) {
		result.put(property, value);
		return this;
	}
}
