package com.zthzinfo.common;


public enum JSPortErrors implements IErrorInfo {
	/**
	 * 手机号或密码不正确
	 */
	PWD_ERROR("JS90000001", "手机号或密码不正确"),
	/**
	 * 登录状态失效
	 */
	LOGIN_INVALID("JSP90000002", "登录状态失效"),
	/**
	 * 请输入正确的数字
	 */
	NUM_CHECK("JSP90000003","请输入正确的数字"),
	/**
	 * 请输入船舶AIS标识码
	 */
	SHIP_MMSI_CHECKNULL("JSP90000004","请输入船舶AIS标识码"),
	/**
	 * 符合该AIS标识符的船已存在
	 */
	SHIP_MMSI_EXIST("JSP90000005","符合该AIS标识符的船已存在"),
	/**
	 * 请输入船舶长度
	 */
	SHIP_LENGTH_CHECKNULL("JSP90000006","请输入船舶长度"),
	/**
	 * 请输入船舶高度
	 */
	SHIP_HEIGHT_CHECKNULL("JSP90000007","请输入船舶高度"),
	/**
	 * 请输入船舶的宽度
	 */
	SHIP_WIDTH_CHECKNULL("JSP90000008","请输入船舶的宽度"),
	/**
	 * 请上传船舶经营许可证图片
	 */
	SHIP_OPERATINGLICENSEPIC_CHECKNULL("JSP90000009","请上传船舶经营许可证图片"),
	/**
	 * 请输入船舶吃水深度
	 */
	SHIP_DRAUGHT_CHECKNULL("JSP90000010","请输入船舶吃水深度"),
	/**
	 * 请输入船舶英文船名
	 */
	SHIP_ENAME_CHECKNULL("JSP90000011","请输入船舶英文船名"),
	/**
	 * 请输入船舶中文船名
	 */
	SHIP_NAME_CHECKNULL("JSP90000012","请输入船舶中文船名"),
	/**
	 * 请选择船舶类型
	 */
	SHIP_SHIPTYPE_CHECKNULL("JSP90000013","请选择船舶类型"),
	/**
	 * 请输入船舶空船载重
	 */
	SHIP_DEADWEIGHT_CHECKNULL("JSP90000014","请输入船舶空船载重"),
	/**
	 * 船舶删除失败
	 */
	SHIP_DELETE_ERROR("JSP90000015","船舶删除失败"),
	/**
	 * 船舶新增失败
	 */
	SHIP_ADD_ERROR("JSP90000016","船舶新增失败"),
	/**
	 * 船舶修改失败
	 */
	SHIP_UPDATE_ERROR("JSP90000017","船舶修改失败"),
	/**
	 * 船舶查询失败
	 */
	SHIP_SELECT_ERROR("JSP90000018","船舶查询失败"),
	/*
	 * 调用OA认证失败
	 */
	FZOA_AUTH_ERROR("JSP90000019","OA认证异常"),
	/**
	 * 提交合同审批为配置模板
	 */
	FZOA_FORM_CONFIG_ERROR("JSP90000020","审核模板配置异常"),
	/**
	 * 提交合同审批失败
	 */
	FZOA_FORM_COMMIT_ERROR("JSP90000021","审核提交出错"),
	/**
	 * 提交合同审批上传附件失败
	 */
	FZOA_FORM_ATTACHMENT_UPLOAD_ERROE("JSP90000022","审核附件上传失败"),
	/**
	 * 提交合同审数据不全
	 */
	FZOA_APPROVAL_DATA_INCOMPLETE("JSP90000023","请提交完整的数据"),
	/**
	 * 请录入审批标题
	 */
	FZOA_APPROVAL_TITLE_CHECKNULL("JSP90000024","请录入审批标题"),
	/**
	 * 请录入合同名称
	 */
	FZOA_APPROVAL_CONTRACT_NAME_CHECKNULL("JSP90000025","请录入合同名称"),
	/**
	 * 请录入合同对方名称
	 */
	FZOA_APPROVAL_CONTRACT_PARTY_NAME_CHECKNULL("JSP90000025","请录入合同对方名称"),
	/**
	 * 请录入合同对方编码
	 */
	FZOA_APPROVAL_CONTRACT_PARTY_CODE_CHECKNULL("JSP90000027","请录入合同对方编码"),
	/**
	 * 请录入承办部门（单位）
	 */
	FZOA_APPROVAL_CONTRACT_ORANIZER_NAME_CHECKNULL("JSP90000028","请录入承办部门（单位）"),
	/**
	 * 请录入承办部门（单位）编码
	 */
	FZOA_APPROVAL_CONTRACT_ORANIZER_CODE_CHECKNULL("JSP90000029","请录入承办部门（单位）编码"),
	/**
	 * 请录入经办人名称
	 */
	FZOA_APPROVAL_CONTRACT_OPERATOR_NAME_CHECKNULL("JSP90000030","请录入经办人名称"),
	/**
	 * 请录入经办人编码
	 */
	FZOA_APPROVAL_CONTRACT_OPERATOR_CODE_CHECKNULL("JSP90000031","请录入经办人编码"),
	/**
	 * 请录入经办人联系电话
	 */
	FZOA_APPROVAL_CONTRACT_OPERATOR_TEL_CHECKNULL("JSP90000032","请录入经办人联系电话"),
	/**
	 * 请录入合同主要内容
	 */
	FZOA_APPROVAL_CONTRACT_CONTENT_CHECKNULL("JSP90000033","请录入合同主要内容"),
	/**
	 * 获取流程状态异常
	 */
	FZOA_FLOW_STATE_ERROR("JSP90000034","获取流程状态异常"),
	/**
	 * 符合该船舶名称的船已存在
	 */
	SHIP_NAME_EXIST("JSP90000035","符合该船舶名称的船已存在");

	private String code;
	private String desc;

	private JSPortErrors(String code, String desc) {
		this.code = code;
		this.desc = desc;
	}

	@Override
	public String getCode() {
		return this.code;
	}


	@Override
	public String getDesc() {
		return this.desc;
	}

}
